/* Nastaveni ESP modulu, ktere pracuje takto:
 * 1. Pokud je forceConfigure ==0, tak se aktivuje WiFi v rezimu AP a cele ESP je mozne nastavit webovym rozhranim (pocitam s prenosem hodnoty nouzoveho tlacitka pri startu).
 * 2. Neni-li tlacitko stisknute, tak se vezme rezim prace a AP se nastavi dle nej (WIFI_STA a WIFI_AP)
 * 3. Pokud byl rezim prace WIFI_STA a ESP se nepripoji k zadne siti do casu WIFI_STA_CONNECT_TIMEOUT, tak se pokracuje jako kdyby bylo stisknute rekonfiguracni tlacitko
 */

#ifndef __WifiConfig_h__
#define __WifiConfig_h__

#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

typedef struct
{
	uint8_t mode; // rezim prace AP/STA
	char ssid[32]; // SSID site
	char pass[64]; // heslo
} wificonfigarea_t;

#ifndef WIFI_STA_CONNECT_TIMEOUT
 #define WIFI_STA_CONNECT_TIMEOUT 50 // delka cekani na pripojeni k AP [*200ms]
#endif

#ifndef SETUP_SSID
 #define SETUP_SSID "ESPPBSetup"
#endif

String getEEPROMString(int start, int len);

void setEEPROMString(int start, int len, String string);

class WifiConfig
{
public:
	void begin(int configarea, uint8_t forceConfigure);
};
#endif