
#include "WifiConfig.h"
#include <EEPROM.h>

extern "C" {
  #include "user_interface.h"
}

#define elementSize(type, element) sizeof(((type *)0)->element) 

extern ESP8266WebServer wwwserver;

#define HTTP_200 F("HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n")
#define HTTP_HEAD F("<!DOCTYPE html><html lang=\"en\"><head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><title>{v}</title>")
#define HTTP_STYLE F("<style>div,input {margin-bottom: 5px;}body{width:200px;display:block;margin-left:auto;margin-right:auto;}</style>")
#define HTTP_SCRIPT F("<script>function c(l){document.getElementById('s').value=l.innerText||l.textContent;document.getElementById('p').focus();}</script>")
#define HTTP_HEAD_END F("</head><body>")
#define HTTP_ITEM F("<div><a href='#' onclick='c(this)'>{v}</a>({a}){s}</div>")
//#define HTTP_FORM F("<form method='get' action='s'><input id='s' name='ssid' length=32 placeholder='SSID'><input id='p' name='pass' length=64 placeholder='password'><br/><label><input id='a' name='AP' type='checkbox'>AP mode</label><br/><input type='submit'></form>")
//#define HTTP_FORM F("<form method='get' action='s'><input id='s' name='ssid' length=32 placeholder='SSID'><input id='p' name='pass' length=64 placeholder='password' type='password'><br/><label><input id='a' name='AP' type='checkbox'>AP mode</label><br/><input type='submit'></form>")
#define HTTP_FORM_1 F("<form method='get' action='s'><input id='s' name='ssid' length=32 {v}>")
#define HTTP_FORM_2 F("<input id='p' name='pass' length=64 {v} type='password'><br/>")
#define HTTP_FORM_3 F("<label><input id='a' name='AP' type='checkbox' {v}>AP mode</label><br/><input type='submit'></form>")
#define HTTP_END F("</body></html>")
	
static uint8_t testWifi(void);

enum
{
	WIFIMODE_AP = 0x55, // rezim prace jako pristupovy bod (AP)
	WIFIMODE_STA = 0xAA // rezim prace jako klient
};

static int configBase;
static String content;

String getEEPROMString(int start, int len)
{
  String string = "";
  
  for (int i = start; i < + start + len; ++i)
  {
    uint8_t b = EEPROM.read(i);

    if ((0xff == b) || (0 == b))
      break;
    string += char(b);
  }
  return string;
}

void setEEPROMString(int start, int len, String string)
{
  int si = 0;
  
  for (int i = start; i < start + len; ++i)
  {
    char c;
    
    if (si < string.length())
    {
      c = string[si];
    }
    else
    {
      c = 0;
    }
    EEPROM.write(i, c);
    ++si;
  }
  EEPROM.commit(); // skutecne ulozime retezec
}

static void handleDisplayAP(void)
{
	String s;
	String v;
	
	content = HTTP_HEAD;
	content.replace("{v}", "xPablo.cz Config");
	content += HTTP_SCRIPT;
	content += HTTP_STYLE;
	content += HTTP_HEAD_END;
	int n = WiFi.scanNetworks();
	if (0 == n)
	{
		content += F("<div>No networks found. Refresh to scan again.</div>");
	}
	else
	{
		for (int i = 0; i < n; ++i)
		{
			String item = HTTP_ITEM;
			item.replace("{v}", WiFi.SSID(i));
			item.replace("{a}", String(WiFi.RSSI(i)));
			item.replace("{s}", (ENC_TYPE_NONE == WiFi.encryptionType(i)) ? " " : "*");
			content += item;
		}
	}
	s = HTTP_FORM_1;
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid));
	if (v.length())
		s.replace("{v}", "value='" + v + "'");
	else
		s.replace("{v}", "placeholder='SSID'");
	content += s;

	s = HTTP_FORM_2;
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass));
	if (v.length())
		s.replace("{v}", "value='" + v + "'");
	else
		s.replace("{v}", "placeholder='password'");
	content += s;
	
	s = HTTP_FORM_3;
	if (EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)) == WIFIMODE_AP)
		s.replace("{v}", "checked='checked'");
	else
		s.replace("{v}", "");
	content += s;

	content += HTTP_END;
	wwwserver.send(200, F("text/html"), content);
}

static void handleSetAP(void)
{
	int httpstatus = 200;
	uint8_t wmode;
	String qsid = wwwserver.arg("ssid");
	String qpass = wwwserver.arg("pass");
	String qap = wwwserver.arg("AP");
  
	if (qsid.length() > 0)
	{
		for (int i = 0; i < qsid.length(); i++)
		{
			// Deal with (potentially) plus-encoded ssid
			qsid[i] = (qsid[i] == '+' ? ' ' : qsid[i]);
		}
		for (int i = 0; i < qpass.length(); i++)
		{
			// Deal with (potentially) plus-encoded password
			qpass[i] = (qpass[i] == '+' ? ' ' : qpass[i]);
		}
		if (qap.length() > 0)
		{ // rezim AP
			wmode = WIFIMODE_AP;
		}
		else
		{ // rezim STA
			wmode = WIFIMODE_STA;
		}
		setEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid), qsid);
		setEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass), qpass);
		EEPROM.write(configBase + offsetof(wificonfigarea_t, mode), wmode);
		content = HTTP_HEAD;
		content.replace("{v}", "Saved config");
		content += HTTP_STYLE;
		content += HTTP_HEAD_END;
		content += F("saved to eeprom...<br/>resetting in 10 seconds.");
		content += HTTP_END;
		wwwserver.send(200, F("text/html"), content);
		delay(10000); // cekame 10 sekund na odeslani dat
		ESP.reset();
	}
	else
	{
		content = HTTP_HEAD;
		content += F("Error, no ssid or password set?</html>");
		wwwserver.send(404, F("text/html"), content);
	}
}

// Start WiFi v rezimu AP pro nastaveni modulu
static void setupAP(void)
{

	WiFi.mode(WIFI_AP);
	WiFi.softAP(SETUP_SSID);
// Nastavime handlery weboveho serveru pro konfiguraci
    wwwserver.on("/", handleDisplayAP);
    wwwserver.on("/s", handleSetAP);
	wwwserver.begin(); // startujeme webovy server
	while (1)
	{
		wwwserver.handleClient(); // osetrujeme praci serveru
		delay(0); // procesy uvnitr systemu ESP potrebuji take svuj cas
	}
}

// Testovani, zda se modul pripojil k AP
static uint8_t testWifi(void)
{
	int c = WIFI_STA_CONNECT_TIMEOUT;
  
	while (c)
	{
		if (WiFi.status() == WL_CONNECTED)
			return 1; // jsme pripojeni
		delay(200);
		--c;
	}
	return 0; // pripojeni se nezdarilo
}
 
void WifiConfig::begin(int configarea, uint8_t forceConfigure)
{

	configBase = configarea; // pocatek konfigurace v EEPROM
	if (0 == forceConfigure)
	{
		setupAP();
	}
	else
	{
		String ssid = getEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid));
		String pass =  getEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass));

		switch (EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)))
		{
		case WIFIMODE_STA:
		{
			WiFi.mode(WIFI_STA); // startujeme WiFi v rezimu klienta
			WiFi.begin(ssid.c_str(), pass.c_str());
			wifi_station_set_auto_connect(true);
			if (false == testWifi())
				setupAP(); // modul se nepripojil - startujeme AP rezim
		}
		break;
		
		case WIFIMODE_AP:
			WiFi.mode(WIFI_AP); // startujeme AP
			if (pass.length())
			// je zadane heslo do AP
				WiFi.softAP(ssid.c_str(), pass.c_str());
			else
			// otevreny AP
				WiFi.softAP(ssid.c_str());
		break;
		
		default: // jakykoliv neznamy rezim (mozna zavada na EEPROM???)
			setupAP();
		break;
		}
	}
}
