#include "RS485.h"
#include <Arduino.h>

#define SERIAL Serial

int txFree; // normalni pocet volnych bytu (pro urceni, ze je TX buffer prazdny)
uint8_t message[40]; // uloziste pro zpravu
int index; // ukazatel ve zprave
enum
{
  RS_STARTHUNT = 0,
  RS_DATA,
}state = RS_STARTHUNT;

void RS485_Begin(int baud)
{

  pinMode(ENABLE_PIN, OUTPUT);  // driver output enable
  digitalWrite(ENABLE_PIN, LOW); // aktivujeme prijem
	SERIAL.begin(baud);
  txFree = SERIAL.availableForWrite();
}

uint8_t *RS485_Receive(void)
{
  uint8_t * result = NULL;

  if (SERIAL.available())
  {
    while (SERIAL.available() && (NULL == result))
    {
      uint8_t b = SERIAL.read();
      switch (state)
      {
      case RS_DATA:
        switch (b)
        {
        case '<':
          index = 0; // restart prijmu
        break;

        case '>':
          message[index] = 0; // ukoncime retezec
          result = message;
        break;

        default:
          message[index] = b;
          ++index;
          if (index == sizeof(message))
            state = RS_STARTHUNT;
        break;
        }
      break;

      default:
        if ('<' == b)
        {
          index = 0; // reinicializujeme ukazatel na zacatek zpravy
          state = RS_DATA;
        }
      break;
      }
    }
  }
  return result;
}

void RS485_Send(String msg)
{

  digitalWrite (ENABLE_PIN, HIGH);  // enable sending
  SERIAL.write('<');
  SERIAL.write(msg.c_str());
  SERIAL.write('>');
  while (SERIAL.availableForWrite() != txFree)
    delay(1); // Delay abit or else the RS485 will switch off before the last byte has been sent.
  delay(1);
  digitalWrite(ENABLE_PIN, LOW);  // disable sending
}
