//
#include "configuration.h"
#include "src/hx711_v2/hx711.h"
#include "src/RS485/RS485.h"
#include "src/interval/interval.h"
#include <EEPROM.h>

//#define ONE_WIRE_PIN 5
#define DOUT_PIN A1 // HX711.DOUT  - pin #A1
#define PD_SCK_PIN A0 // HX711.PD_SCK  - pin #A0
#define LEDPIN 13

template <class T> int EEPROM_writeAnything(int ee, const T& value)
{
   const byte* p = (const byte*)(const void*)&value;
   int i;
   for (i = 0; i < sizeof(value); i++)
       EEPROM.write(ee++, *p++);
   return i;
}

template <class T> int EEPROM_readAnything(int ee, T& value)
{
   byte* p = (byte*)(void*)&value;
   int i;
   for (i = 0; i < sizeof(value); i++)
       *p++ = EEPROM.read(ee++);
   return i;
}

Hx711 scale(DOUT_PIN, PD_SCK_PIN);    // parameter "gain" is ommited; the default value 128 is used by the library

const char VERSION[] = INOVER;

Interval led;
uint8_t ledstate;

void pause(void)
{

  delay(50);
}

void setup(void)
{
  float c;

  RS485_Begin(19200); // aktivujeme RS485
  pinMode(LEDPIN, OUTPUT);
  EEPROM_readAnything(0, c); // precteme si kalibracni hodnotu
  scale.setScale(c); // nakalibrujeme vahu
}

void loop(void)
{

  uint8_t *ptr = RS485_Receive();
  if (ptr)
  { // prijali jsme zpravu
    String s = ptr;
    if (s.length())
    {
      s.toUpperCase(); // vse velkymi pismeny
      switch (s[0])
      {
      case 'I': // identifikace senzoru
        pause();
        RS485_Send(VERSION);
      break;

      case 'M': // mereni
      {
        String s = "M:";
        s += scale.getGram();
        pause();
        RS485_Send(s);
      }
      break;

      case 'S': // nastaveni vazici konstanty (kalibrace vahy)
      {
      	s.remove(0,2); // odstranime <Povel>:
      	float f = s.toFloat();
      	EEPROM_writeAnything(0, f); // ulozime kalibracni konstantu
      	scale.setScale(f); // nakalibrujeme merici element
      	String r = "S:";
      	EEPROM_readAnything(0, f);
      	r += f;
      	pause();
      	RS485_Send(r);
      }
      break;

      case 'V': // ziskani surove hodnoty z HX711
      {
      	if (s[1] == ':')
      	{
      	  s.remove(0, 2); // odstranime povel a dvojtecku
      	  String r = "V:";
      	  r += scale.averageValue(s.toInt());
      	  pause();
      	  RS485_Send(r);
      	}
      	else
      	{
      	  String s = "V:";
      	  s += scale.getValue();
      	  pause();
      	  RS485_Send(s);
      	}
      }
      break;
      }
    }
  }
  if (led.expired())
  {
    if (ledstate)
    {
      digitalWrite(LEDPIN, HIGH);
      ledstate = 0;
    }
    else
    {
      digitalWrite(LEDPIN, LOW);
      ledstate = 1;
    }
    led.set(500);
  }
}
