
#include "configuration.h"

#include "nvt.h"
#include "nvt_int.h"
#include <string.h>

static uint8_t DONOTIFYLINESTATE[] = {NVT_IAC, NVT_DO, COM_PORT_OPTION};
static uint8_t NOTIFYMODEMSTATE[] = {NVT_IAC, NVT_SB, COM_PORT_OPTION, ASC_NOTIFY_MODEMSTATE, 16 + 64, NVT_IAC, NVT_SE};

static const char TXBFROVFL[] PROGMEM = "NVT: tx buffer overflow";

void nvt::puttotx(uint8_t c)
{

  if (_txptr < sizeof(_nvttxbuff))
  {
    _nvttxbuff[_txptr] = c;
    ++_txptr;
  }
  else
    TRACE(TRACE_ERROR, FPSTR(TXBFROVFL));
}

void nvt::puttotxesc(uint8_t c)
{

  if ((_txptr + 1) < sizeof(_nvttxbuff))
  {
    _nvttxbuff[_txptr] = c;
    ++_txptr;
    if (NVT_IAC == c)
    {
      _nvttxbuff[_txptr] = c;
      ++_txptr;
    }
  }
  else
    TRACE(TRACE_ERROR, FPSTR(TXBFROVFL));
}

void nvt::outdata(uint8_t *ptr, size_t size)
{

  if (_netchr)
  {
    while (size)
    {
      _netchr(*ptr);
      ++ptr;
      --size;
    }
  }
}

int nvt::getnvtbyte(uint8_t *dta)
{

  if (_getindex < _cmdindex)
  {
    *dta = _nvtcmd[_getindex];
    _getindex++;
    return 0;
  }
  else
    return -1; // neni dalsi byte
}

// Zpracovani NVT povelu
void nvt::donvtcmd(void)
{
  uint8_t dta;
  uint8_t cmd;
  bool wontquit = true;
  uint32_t parameter;

  _getindex = 0;

  if (0 == getnvtbyte(&dta))
//  while ((0 == getnvtbyte(&dta)) && wontquit)
  {
    switch (dta)
    {
      case COM_PORT_OPTION:
        if (0 == getnvtbyte(&cmd))
        {
          switch (cmd)
          {
            case CAS_SIGNATURE:
              break;

            case CAS_SET_BAUDRATE:
              if ((_cmdindex - _getindex) >= 4)
              {
                getnvtbyte(&dta);
                parameter = dta << 24;
                getnvtbyte(&dta);
                parameter += dta << 16;
                getnvtbyte(&dta);
                parameter += dta << 8;
                getnvtbyte(&dta);
                parameter += dta;
                if (0 != parameter)
                {
                  _speed = parameter;
                  _setserial(_speed, -_databits, -_parity, -_stopbits); // aktualizujeme prenosovou rychlost
                }
                parameter = _speed;
              }
              break;

            case CAS_SET_DATASIZE:
              if (0 == getnvtbyte(&dta))
              {
                if (0 != dta)
                {
                  _databits = dta;
                  _setserial(-_speed, _databits, -_parity, -_stopbits);
                }
                parameter = _databits;
              }
              break;

            case CAS_SET_PARITY:
              if (0 == getnvtbyte(&dta))
              {
                if (0 != dta)
                {
                  _parity = dta;
                  _setserial(-_speed, -_databits, _parity, -_stopbits);
                }
                parameter = _parity;
              }
              break;

            case CAS_SET_STOPSIZE:
              if (0 == getnvtbyte(&dta))
              {
                if (0 != dta)
                {
                  _stopbits = dta;
                  _setserial(-_speed, -_databits, -_parity, _stopbits);
                }
                parameter = _stopbits;
              }
              break;

            case CAS_SET_CONTROL:
              if (0 == getnvtbyte(&dta))
              {
                if (_setgetcontrol)
                  parameter = _setgetcontrol(dta);
                else
                  parameter = 1; // No Flow Control available
                TRACE(TRACE_INFO, F("Set/Get Control returns %i"), (int)parameter);
              }
              break;

            case CAS_SET_LINESTATE_MASK:
              if (0 == getnvtbyte(&dta))
              {
                _linestatemask = dta;
                parameter = _linestatemask;
                TRACE(TRACE_INFO, F("Line state mask set to %i"), (int)_linestatemask);
              }
            break;

            case CAS_SET_MODEMSTATE_MASK:
              if (0 == getnvtbyte(&dta))
              {
                _modemstatemask = dta;
                parameter = _modemstatemask;
                TRACE(TRACE_INFO, F("Modem state mask set to %i"), (int)_modemstatemask);
              }
            break;

            default:
              TRACE(TRACE_ERROR, F("Unsupported CAS %i"), (int)dta);
              wontquit = false;
              break;
          }
// odeslani odpovedi
          if (wontquit)
          {
            _txptr = 0;
            puttotx(NVT_IAC);
            puttotx(NVT_SB);
            puttotx(COM_PORT_OPTION);
            puttotx(cmd + 100); // z dotazu udelame odpoved
            if (CAS_SET_BAUDRATE == cmd)
            { // nastaveni/dotaz na prenosovou rychlost vraci 4 byty
              puttotxesc((parameter >> 24) & 0xff);
              puttotxesc((parameter >> 16) & 0xff);
              puttotxesc((parameter >> 8) & 0xff);
              puttotxesc((parameter >> 0) & 0xff);
            }
            else
            {
              puttotxesc(parameter & 0xff); // ostatni povely vraci jeden byte
            }
            puttotx(NVT_IAC);
            puttotx(NVT_SE);
            outdata(_nvttxbuff, _txptr);
          }
        }
        break;

      default:
        TRACE(TRACE_ERROR, F("Unsupported cmd %i"), (int)dta);
        break;
    }
  }
}

// Standardni metoda pro prepousteni dat do vystupu
void nvt::terminalbyte(uint8_t dta)
{

  if (_putchr)
    _putchr(dta);
}

// metoda reseni subnegotiation options
void nvt::subnegotiationbyte(uint8_t dta)
{

  _nvtcmd[_cmdindex] = dta;
  _cmdindex++;
  if (MAX_NVT_CMD_SIZE == _cmdindex)
  { // preteceni bufferu
    _streamstate = NVT_IAC_HUNT; // rusime zpracovani povelu
    TRACE(TRACE_ERROR, F("Internal buffer overflow"));
  }
}

// Standardni metoda reakce na NVT povel
void nvt::terminalescape(uint8_t dta)
{

  switch (dta)
  {
    case NVT_NOP:
      break;

    case NVT_AYT:
      {
        if (0 == strlen(_aytstring))
          outdata((uint8_t*)"Yes", 3); // genericka odpoved
        else
          outdata((uint8_t *)_aytstring, strlen(_aytstring)); // uzivatelska odpoved
      }
      break;

    case NVT_SB: // zacatek subnegotiation
      _streamstate = NVT_SB_FOUND; // nasli jsme zacatek subnegotiation
      _cmdindex = 0; // nastavime index na zacatek
      break;

    case NVT_SE: // konec subnegotiation
      _streamstate = NVT_IAC_HUNT; // rusime osetrovani subnegotiation
      if (_cmdindex)
        donvtcmd(); // zpracujeme NVT povel
      break;

    case NVT_WILL:
    case NVT_WONT:
    case NVT_DO:
    case NVT_DONT:
      wwdd = dta; // ulozime si typ povelu WILL/WONT/DO/DONT
      _streamstate = NVT_WILL_WONT_DO_DONT_PARAM; // priste budeme analyzovat parametr
      break;

    default:
      // Detekovan neznamy znak po <IAC>
      TRACE(TRACE_ERROR, F("Unknown NVT %i"), (int)dta);
      break;
  }
}

void nvt::handlewwddp(uint8_t p)
{

  TRACE(TRACE_INFO, F("DO/DONT/WILL/WONT"));
  _txptr = 0;
  puttotx(NVT_IAC);
  switch (wwdd)
  {
  case NVT_WILL:
    if (COM_PORT_OPTION == p)
      puttotx(NVT_DO);
    else
      puttotx(NVT_DONT);
  break;

  case NVT_WONT:
    puttotx(NVT_DONT);
  break;

  case NVT_DO:
    if (COM_PORT_OPTION == p)
      puttotx(NVT_WILL);
    else
      puttotx(NVT_WONT);
  break;

  case NVT_DONT:
    puttotx(NVT_WONT);
  break;
  }
  puttotx(p);
  outdata(_nvttxbuff, _txptr);
}

void nvt::parsenvtstream(uint8_t dta)
{

  switch (_streamstate)
  {
    case NVT_SB_FOUND:
      if (NVT_IAC == dta)
        _streamstate = NVT_IAC_SB_FOUND;
      else
        subnegotiationbyte(dta); // prijimame bezny byte z SB - SE povelu
    break;

    case NVT_IAC_SB_FOUND:
      _streamstate = NVT_SB_FOUND;
      if (NVT_IAC == dta)
        subnegotiationbyte(dta); // byl to obycejny <IAC><IAC> escapovany byte ze subnegotiation sekvence
      else
        terminalescape(dta); // byl to nejaky povel - doufame, ze to byl <SE>
    break;

    case NVT_IAC_FOUND:
      _streamstate = NVT_IAC_HUNT;
      if (NVT_IAC == dta)
        terminalbyte(dta); // data do vystupu (->serial)
      else // slo o <IAC><povel> - signalizujeme IAC
        terminalescape(dta);
      break;

    case NVT_WILL_WONT_DO_DONT_PARAM:
      _streamstate = NVT_IAC_HUNT;
      handlewwddp(dta);
    break;

    default:
      _streamstate = NVT_IAC_HUNT;
    case NVT_IAC_HUNT:
      if (NVT_IAC != dta)
        terminalbyte(dta); // data do vystupu
      else
        _streamstate = NVT_IAC_FOUND;
      break;
  }
}

void nvt::handlestream(uint8_t *ptr, int len)
{

  while (len)
  {
    parsenvtstream(*ptr);
    ++ptr;
    --len;
  }
}

void nvt::createsendstream(uint8_t *ptr, int len)
{
  uint8_t dta;

  while (len)
  {
    dta = *ptr;
    ++ptr;
    --len;
    if (_netchr)
    {
      _netchr(dta);
      if (NVT_IAC == dta)
      { // NVT_IAC je escapovany
        _netchr(dta);
      }
    }
  }
}

void nvt::init(setserial_cb setserial, putchr_cb putchr, netchr_cb netchr)
{

  _setserial = setserial;
  _putchr = putchr;
  _netchr = netchr;
  _speed = NVT_INITIAL_SPEED;
  _databits = NVT_INITIAL_DATA_BITS;
  _parity = NVT_INITIAL_PARITY;
  _stopbits = NVT_INITIAL_STOP_BITS;
  _setserial(_speed, _databits, _parity, _stopbits);
  _streamstate = NVT_IAC_HUNT;
  _modemstatemask = 0;
  _linestatemask = 0;
}

void nvt::setAYTstring(const char *aytstring)
{

  strcpy(_aytstring, aytstring);
}

void nvt::newguy(void)
{

//  outdata(DONOTIFYLINESTATE, sizeof(DONOTIFYLINESTATE)); // zajima nas zmena stavu ridicich signalu
//  outdata(NOTIFYMODEMSTATE, sizeof(NOTIFYMODEMSTATE));
}

void nvt::setSetGetCtrl(setgetcontrol_cb sgc)
{

  _setgetcontrol = sgc;
}

// EOF

