/*
 * V3.0 - 27.2.2016 - pridana presmerovavaci stranka kvuli Captive portalu, doplneno servirovani favicon.ico, doplnena moznost zadavani uzivatelskych parametru, www server a DNS server jsou dynamicky vytvareny
 * 
 * V2.4 - 7.2.2016  - upraveno casovani pri pripojovani k AP (zmizel delay(100))
 *
 * V2.3 - 5.2.2016  - pridano zverejneni jmena hosta a nastaveni tohoto jmena pro DHCP apod.
 *
 * V2.2 - 19.1.2016 - pridan Captive portal pri konfiguracnim AP.
 *
 * V2.1 - 20.9.2015 - pridano zadavani jmena zarizeni. Modul ho sice nevyuziva, ale aplikace ano a v pripade DHCP se dost hodi.
 *
 * V2.0 - 30.8.2015 - Podstatnym zpusobem vylepsena signalizace vnitrniho stavu, presunuto ulozeni rezimu (commit je uz zbytecny - udela se pri ukladani retezcu - uspora kodu)
 *
 * V1.2 - 23.8.2015 - BugFix - pridan chybejici eeprom.commit po ulozeni rezimu prace
 *
 * V1.1 - 5.8.2015 - pridana moznost volani callback metody pri behu konfiguracniho AP (signalizace stavu uzivatelskym zpusobem)
 *
 * V1.0 - publikace na www.xpablo.cz
 *
 * TODO:
 */
 
#include "WiFiConfig.h"
#include <DNSServer.h>
#include <EEPROM.h>
#include "embHTML.h"

#define DEBUG_OUT(a) {}
//#define DEBUG_OUT(a) Serial.print(a)

extern "C" {
  #include "user_interface.h"
}

#define elementSize(type, element) sizeof(((type *)0)->element) 
#define DNS_PORT 53

char WiFiDeviceName[elementSize(wificonfigarea_t, devname)]; // misto pro jmeno zarizeni (dodane do DNS, DHCP NBNS apod...)

static uint8_t testWifi(wificonfig_cb cb);

enum
{
	WIFIMODE_AP = 0x55, // rezim prace jako pristupovy bod (AP)
	WIFIMODE_STA = 0xAA // rezim prace jako klient
};

static int configBase; // musi byt trvale ulozene, aby fungovaly metody pro ziskani retezcu z EEPROM

IPAddress getOurIP(void)
{

	if (WIFIMODE_STA == EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)))
		return WiFi.localIP();
	else
		return WiFi.softAPIP();
}

uint8_t * getOurMAC(uint8_t *mac)
{

	if (WIFIMODE_STA == EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)))
		return WiFi.macAddress(mac);
	else
		return WiFi.softAPmacAddress(mac);
}

String getEEPROMString(int start, int len)
{
  String string = "";
  
  for (int i = start; i < + start + len; ++i)
  {
    uint8_t b = EEPROM.read(i);

    if ((0xff == b) || (0 == b))
      break;
    string += char(b);
  }
  return string;
}

void setEEPROMString(int start, int len, String string)
{
  int si = 0;
  
  for (int i = start; i < start + len; ++i)
  {
    char c;
    
    if (si < string.length())
    {
      c = string[si];
    }
    else
    {
      c = 0;
    }
    EEPROM.write(i, c);
    ++si;
  }
  EEPROM.commit(); // skutecne ulozime retezec
}

// http://www.esp8266.com/viewtopic.php?t=8402&p=41956#p41956
int clients()
{
  int ans=0;
  struct station_info *stat_info;
  stat_info=wifi_softap_get_station_info();
  while (stat_info != NULL) {
    ans++;
    stat_info = STAILQ_NEXT(stat_info, next);
  }
  wifi_softap_free_station_info();
  return ans;
}

WiFiConfigUsrParameter::WiFiConfigUsrParameter(const char *id, const char *placeholder, const char *defaultValue, int length, storeparam_cb cb)
{
  _next = NULL;
  _cb = cb;
  _id = id;
  _placeholder = placeholder;
  _length = length;
  _value = new char[length + 1];
  for (int i = 0; i < length; i++)
  {
    _value[i] = 0;
  }
  if (defaultValue != NULL)
  {
    strncpy(_value, defaultValue, length);
  }
}

const char* WiFiConfigUsrParameter::getValue()
{

  return _value;
}

const char* WiFiConfigUsrParameter::getID()
{

  return _id;
}

const char* WiFiConfigUsrParameter::getPlaceholder()
{

  return _placeholder;
}

int WiFiConfigUsrParameter::getValueLength()
{

  return _length;
}

void WiFiConfigUsrParameter::setNext(WiFiConfigUsrParameter *n)
{

  _next = n;
}

WiFiConfigUsrParameter *WiFiConfigUsrParameter::getNext()
{

  return _next;
}

void WiFiConfigUsrParameter::setNewValue(const char *newval)
{

	if (0 != strcmp(_value, newval))
		_cb(newval);
}

WiFiConfigUsrParameter *WiFiConfig::searchUsrParameter(const char *name)
{
  WiFiConfigUsrParameter *ptr = _params;

  while (NULL != ptr)
  {
  	if (0 == strcmp(name, ptr->getID()))
  		break;
  	ptr = ptr->getNext();
  }
  return ptr;
}

void WiFiConfig::addParameter(WiFiConfigUsrParameter *p)
{
	p->setNext(_params);
	_params = p;
}

void WiFiConfig::handleNotFound(void)
{

	DEBUG_OUT("Requested URI: ");
	DEBUG_OUT(server->uri());
	DEBUG_OUT("\r\n");
	if (server->uri().endsWith(String("favicon.ico")))
	{
   		server->send(404, "text/plain", "");
	}
	else
	{
		String content = FPSTR(PAGE_CAPTIVEPORTALCATCH);
		content.replace("{v}", String("http://") + server->client().localIP().toString() + String("/config"));
    	server->send (200, "text/html", content);
	}
}

void WiFiConfig::handleDisplayAP(void)
{
	String s;
	String v;
	String content;

	content = FPSTR(PAGE_INDEX1);
	int n = WiFi.scanNetworks();
	if (0 == n)
	{
		content += FPSTR(PAGE_NO_SSID);
	}
	else
	{
		for (int i = 0; i < n; ++i)
		{
			s = FPSTR(PAGE_ITEM);
			s.replace("{v}", WiFi.SSID(i));
			s.replace("{a}", String(WiFi.RSSI(i)));
			s.replace("{s}", (ENC_TYPE_NONE == WiFi.encryptionType(i)) ? "" : "<img id=\"lock\">");
			content += s;
		}
	}
	s = FPSTR(PAGE_INDEX2);
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid));
	if (v.length())
		s.replace("{s}", "value='" + v + "'");
	else
		s.replace("{s}", "placeholder='SSID'");
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass));
	if (v.length())
		s.replace("{p}", "value='" + v + "'");
	else
		s.replace("{p}", "placeholder='password'");
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, devname), elementSize(wificonfigarea_t, devname));
	if (v.length())
		s.replace("{n}", "value='" + v + "'");
	else
		s.replace("{n}", "placeholder='name'");
	if (EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)) == WIFIMODE_AP)
		s.replace("{a}", "checked='checked'");
	else
		s.replace("{a}", "");
	content += s;
// pridani uzivatelskych parametru
	WiFiConfigUsrParameter *up = _params;

	char parLength[4];

	while (NULL != up)
	{
		s = FPSTR(PAGE_PARAM);
		s.replace("{i}", up->getID());
		s.replace("{n}", up->getID());
		snprintf(parLength, sizeof(parLength), "%d", up->getValueLength());
		s.replace("{l}", parLength);
		s.replace("{p}", up->getPlaceholder());
		s.replace("{v}", up->getValue());
		content += s;
		up = up->getNext();
	}

	content += FPSTR(PAGE_END);
	server->send(200, F("text/html"), content);
}

void WiFiConfig::handleSetAP(void)
{
	uint8_t wmode;
	String qsid = server->arg("ssid");
	String qpass = server->arg("pass");
	String qap = server->arg("AP");
	String name = server->arg("name");
  
	if (qsid.length() > 0)
	{
  		for (uint8_t i = 0; i < server->args(); i++ )
  		{
  			WiFiConfigUsrParameter *ptr = searchUsrParameter(server->argName(i).c_str());
  			if (NULL != ptr)
  				ptr->setNewValue(server->arg(i).c_str());
  		}
		for (int i = 0; i < qsid.length(); i++)
		{
			// Deal with (potentially) plus-encoded ssid
			qsid[i] = (qsid[i] == '+' ? ' ' : qsid[i]);
		}
		for (int i = 0; i < qpass.length(); i++)
		{
			// Deal with (potentially) plus-encoded password
			qpass[i] = (qpass[i] == '+' ? ' ' : qpass[i]);
		}
		if (qap.length() > 0)
		{ // rezim AP
			wmode = WIFIMODE_AP;
		}
		else
		{ // rezim STA
			wmode = WIFIMODE_STA;
		}
		EEPROM.write(configBase + offsetof(wificonfigarea_t, mode), wmode);
		setEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid), qsid);
		setEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass), qpass);
		setEEPROMString(configBase + offsetof(wificonfigarea_t, devname), elementSize(wificonfigarea_t, devname), name);
//		EEPROM.commit(); // skutecne ulozime data
	}
	server->send(200, F("text/html"), FPSTR(PAGE_SAVED));
	delay(10000); // cekame 10 sekund na odeslani dat
	ESP.restart();
}

void WiFiConfig::handle204()
{

  server->sendHeader("Cache-Control", "no-cache, no-store, must-revalidate");
  server->sendHeader("Pragma", "no-cache");
  server->sendHeader("Expires", "-1");
  server->send ( 204, "text/plain", "");
}
 
// Start WiFi v rezimu AP pro nastaveni modulu
void WiFiConfig::setupAP(wificonfig_cb cb)
{

	dnsServer.reset(new DNSServer());
	server.reset(new ESP8266WebServer(80));
	
	/* Soft AP network parameters */
	IPAddress apIP(192, 168, 4, 1);
	IPAddress netMsk(255, 255, 255, 0); 

	WiFi.mode(WIFI_AP);

	WiFi.softAPConfig(apIP, apIP, netMsk); 
	WiFi.softAP(SETUP_SSID);
	delay(500); // dulezite - jinak se nevraci spravna IP adresa !!!

	dnsServer->setErrorReplyCode(DNSReplyCode::NoError);
	dnsServer->start(DNS_PORT, "*", WiFi.softAPIP()); // spustime tzv. Captive portal - vsechny DNS dotazy jsou smerovany na nasi ip adresu
	if (cb)
		cb(WCS_CONFIGSTART); // signalizujeme start konfiguracniho serveru
// Nastavime handlery weboveho serveru pro konfiguraci
	server->onNotFound(std::bind(&WiFiConfig::handleNotFound, this));
	server->on("/config", std::bind(&WiFiConfig::handleDisplayAP, this));
    server->on("/s", std::bind(&WiFiConfig::handleSetAP, this));
//	server->on("/generate_204", std::bind(&WiFiConfig::handle204, this));  //Android/Chrome OS captive portal check.
	server->begin(); // startujeme webovy server
	while (1)
	{
		server->handleClient(); // osetrujeme praci serveru
		if (cb)
			cb(WCS_CONFIGWAIT); // volame uzivatelsky callback (napr. signalizace)
		dnsServer->processNextRequest();
		delay(0); // procesy uvnitr systemu ESP potrebuji take svuj cas
	}
}

// Testovani, zda se modul pripojil k AP
static uint8_t testWifi(wificonfig_cb cb)
{
	uint32_t startt = millis();
  
	while ((millis() - startt) < WIFI_STA_CONNECT_TIMEOUT)
	{
		if (WiFi.status() == WL_CONNECTED)
		{
			return 1; // jsme pripojeni
		}
		delay(0);
		if (cb)
			cb(WCS_CONNECTING); // signalizujeme pokracujici pokus o spojeni
	}
	return 0; // pripojeni se nezdarilo
}
 
void WiFiConfig::begin(int configarea, uint8_t forceConfigure, wificonfig_cb cb)
{

	configBase = configarea; // pocatek konfigurace v EEPROM
	if (0 == forceConfigure)
	{
		setupAP(cb);
	}
	else
	{
		String ssid = getEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid));
		String pass =  getEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass));
		String hname = getEEPROMString(configBase + offsetof(wificonfigarea_t, devname), elementSize(wificonfigarea_t, devname));
		strcpy(WiFiDeviceName, hname.c_str());

		switch (EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)))
		{
		case WIFIMODE_STA:
		{
			WiFi.mode(WIFI_STA); // startujeme WiFi v rezimu klienta
			if (strlen(WiFiDeviceName))
				WiFi.hostname(WiFiDeviceName); // nastavime jmeno zarizeni
			WiFi.begin(ssid.c_str(), pass.c_str());
			wifi_station_set_auto_connect(true);
			if (cb)
				cb(WCS_CONNECTSTART); // signalizujeme zacatek pokusu o pripojeni
			if (false == testWifi(cb))
				setupAP(cb); // modul se nepripojil - startujeme AP rezim
		}
		break;
		
		case WIFIMODE_AP:
			WiFi.mode(WIFI_AP); // startujeme AP
			if (pass.length())
			// je zadane heslo do AP
				WiFi.softAP(ssid.c_str(), pass.c_str());
			else
			// otevreny AP
				WiFi.softAP(ssid.c_str());
			if (cb)
				cb(WCS_CONNECTSTART); // signalizujeme zacatek pokusu o pripojeni (zde se nic jineho stejne nestane...)
		break;
		
		default: // jakykoliv neznamy rezim (mozna zavada na EEPROM???)
			setupAP(cb);
		break;
		}
	}
}
