#include <ESP8266WiFi.h>
#include <ArduinoOTA.h>
#include "configuration.h"

void otaError(ota_error_t error)
{
  Serial.println(F("Error."));
}

void otaProgress(unsigned int actual, unsigned int maxsize)
{
}

void otaStart()
{
  Serial.println(F("Start."));
}

void otaEnd()
{
  Serial.println(F("End."));
}

void ICACHE_FLASH_ATTR setup()
{

  Serial.begin(9600); // pro pripadne ladici vystupy
  Serial.println(F("Starting..."));
  WiFi.persistent(false);
  WiFi.mode(WIFI_AP);
  WiFi.softAP(SETUP_SSID);
  ArduinoOTA.setHostname("APOTA");
  ArduinoOTA.onStart(otaStart);
  ArduinoOTA.onEnd(otaEnd);
  ArduinoOTA.onProgress(otaProgress);
  ArduinoOTA.onError(otaError);
  ArduinoOTA.begin();
  Serial.println(F("Setup end."));
}

void loop()
{

  ArduinoOTA.handle();
}
// EOF

