// Hlavicka stranky, skript, ikony
static const char PAGE_INDEX1[] PROGMEM = R"=====(
<!DOCTYPE html><html lang="en"><head><meta name="viewport" content="width=device-width, initial-scale=1"/><title>xPablo.cz Setup</title>
<style>div,input {margin-bottom: 5px;}body{width:200px;display:block;margin-left:auto;margin-right:auto;}
#lock {
   background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAALVBMVEX///8EBwfBwsLw8PAzNjaCg4NTVVUjJiZDRUUUFxdiZGSho6OSk5Pg4eFydHTCjaf3AAAAZElEQVQ4je2NSw7AIAhEBamKn97/uMXEGBvozkWb9C2Zx4xzWykBhFAeYp9gkLyZE0zIMno9n4g19hmdY39scwqVkOXaxph0ZCXQcqxSpgQpONa59wkRDOL93eAXvimwlbPbwwVAegLS1HGfZAAAAABJRU5ErkJggg==");
   padding: 5px 0 5px 30px
}
</style>
<script>function c(l){document.getElementById('s').value=l.innerText||l.textContent;document.getElementById('p').focus();}</script>
</head><body>)=====";

/* Polozky nalezenych SSID
{v} - SSID
{a} - RSSI (kvalita signalu v %)
{s} - bud nic, nebo <img id="lock">
*/
static const char PAGE_ITEM[] PROGMEM = R"=====(
<div><a href='#' onclick='c(this)'>{v}</a>({a}){s}</div>)=====";

/* Zacatek formulare pro vyplneni
{s} - SSID
{p} - password
{n} - Netbios name
{a} - AP mode
*/
static const char PAGE_INDEX2[] PROGMEM = R"=====(
<form method='post' action='s'>
<input id='s' name='ssid' length=32 required {s}>
<input id='p' name='pass' length=64 {p} type='password'><br/>
<input id='n' name='name' length=32 pattern='^[a-zA-Z][a-zA-Z0-9-_\\.]{1,32}$' title='Jmeno dle NetBios konvence (max. 16 znaku pismena, cisla a znaky "_.")' {n}><br/>
<label><input id='a' name='AP' type='checkbox' {a}>AP mode</label><br/>)=====";
// IPV4 validator '((^|\.)((25[0-5])|(2[0-4]\d)|(1\d\d)|([1-9]?\d))){4}$'

// Uzivatelsky pridane polozky
static const char PAGE_PARAM[] PROGMEM = R"=====(
<input id='{i}' name='{n}' length={l} placeholder='{p}' value='{v}'><br/>)=====";

// Konec formulare a stranky
static const char PAGE_END[] PROGMEM = R"=====(
<input type='submit'></form>
</body></html>
)=====";

// Nenalezeno zadne SSID
static const char PAGE_NO_SSID[] PROGMEM = R"=====(
<div>No networks found. Refresh to scan again.</div>
)=====";

// Konfigurace ulozena - restartuji...
static const char PAGE_SAVED[] PROGMEM = R"=====(
<!DOCTYPE html><html lang="en"><head><meta name="viewport" content="width=device-width, initial-scale=1"/><title>xPablo Setup - Config saved</title>
<style>div,input {margin-bottom: 5px;}body{width:200px;display:block;margin-left:auto;margin-right:auto;}</style>
</head><body>
saved to eeprom...<br/>
resetting in 10 seconds.
</body></html>
)=====";

static const char PAGE_NOSSID[] PROGMEM = R"=====(
<!DOCTYPE html><html lang="en"><head><meta name="viewport" content="width=device-width, initial-scale=1"/><title>xPablo Setup - Config Error</title>
<style>div,input {margin-bottom: 5px;}body{width:200px;display:block;margin-left:auto;margin-right:auto;}</style>
</head><body>
Error, no ssid set?
</body></html>
)=====";

static const char PAGE_CAPTIVEPORTALCATCH[] PROGMEM = R"=====(
<!DOCTYPE html><html lang="en"><head><meta name="viewport" content="width=device-width, initial-scale=1"/><title>xPablo Setup - Redirector</title>
<style>div,input {margin-bottom: 5px;}body{width:200px;display:block;margin-left:auto;margin-right:auto;}</style>
</head><body>
Pro nastaveni klikni na <a href="{v}"><button>Nastaveni</button></a>
</body></html>
)=====";
