//#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <ArduinoOTA.h>
#include <EEPROM.h>
#include <SPI.h>
#include <espnbns.h>
#include "libraries/Adafruit_ILI9340_AS8/Adafruit_ILI9340_AS8.h"
#include <Adafruit_GFX_AS8.h>
#include "libraries/XPT2046_T/XPT2046_T.h"
#include "libraries/WiFiConfig/WiFiConfig.h" // WiFiConfig xpablo.cz

#define FORCE_CONFIG_BUTTON_PIN 3 // zatim RX pin slouzi take jako vynuceni konfigurace

// For the Esp connection of touch
#define TFT_DC 2
#define TFT_CS 15

// Definice obsazeni EEPROM
#define elementSize(type, element) sizeof(((type *)0)->element)
typedef struct
{
  wificonfigarea_t wc; // oblast, vyhrazena pro konfiguraci WiFi
} eepromdata_t;

NBNS nbns; // Netbios (xPablo.cz)

//Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC);
Adafruit_ILI9340_AS8 tft = Adafruit_ILI9340_AS8(TFT_CS, TFT_DC);
XPT2046 touch(/*cs=*/ 4, /*irq=*/ 5);

Adafruit_GFX_Button button;

static void wificfgcb(wificonfigstate_t state)
{

  switch (state)
  {
    case WCS_CONNECTSTART:
      break;

    case WCS_CONNECTING:
      break;

    case WCS_CONFIGSTART:
      break;

    case WCS_CONFIGWAIT:
      break;
  }
}

static void pollWiFi(void)
{
  nbns.poll();
  ArduinoOTA.handle();
}

static void calibratePoint(uint16_t x, uint16_t y, uint16_t &vi, uint16_t &vj) {
  // Draw cross
  tft.drawFastHLine(x - 8, y, 16, 0xff);
  tft.drawFastVLine(x, y - 8, 16, 0xff);
  while (!touch.isTouching()) {
    pollWiFi();
    delay(10);
  }
  touch.getRaw(vi, vj);
  // Erase by overwriting with black
  tft.drawFastHLine(x - 8, y, 16, 0);
  tft.drawFastVLine(x, y - 8, 16, 0);
}

void calibrate() {
  uint16_t x1, y1, x2, y2;
  uint16_t vi1, vj1, vi2, vj2;
  touch.getCalibrationPoints(x1, y1, x2, y2);
  calibratePoint(x1, y1, vi1, vj1);
  delay(1000);
  calibratePoint(x2, y2, vi2, vj2);
  touch.setCalibration(vi1, vj1, vi2, vj2);


  tft.setTextColor(ILI9340_CYAN);
  tft.setTextSize(2);
  tft.println("Calibration Params");
  tft.println("");
  tft.setTextSize(3);
  tft.println(vi1);
  tft.println(vj1);
  tft.println(vi2);
  tft.println(vj2);
}

void setup() {
  WiFiConfig wifi; // konfigurace ESP modulu (xPablo.cz)

  EEPROM.begin(512); // zahajujeme praci s EEPROM
  pinMode(FORCE_CONFIG_BUTTON_PIN, INPUT_PULLUP);
  wifi.begin(0, digitalRead(FORCE_CONFIG_BUTTON_PIN), wificfgcb); // startujeme pripojeni
  Serial.begin(9600); // spustime seriovy port (rychlost odpovida ID12)

  if (strlen(WiFiDeviceName))
  {
    nbns.begin(WiFiDeviceName);
    ArduinoOTA.setHostname(WiFiDeviceName);
  }

  ArduinoOTA.onStart([]() {
  });
  ArduinoOTA.onEnd([]() {
  });
  ArduinoOTA.onError([](ota_error_t error) {
    switch (error)
    {
      case OTA_AUTH_ERROR:
        break;

      case OTA_BEGIN_ERROR:
        break;

      case OTA_CONNECT_ERROR:
        break;

      case OTA_RECEIVE_ERROR:
        break;

      case OTA_END_ERROR:
        break;

      default:
        break;
    }
  });
  ArduinoOTA.begin();

  touch.begin(tft.width(), tft.height());  // Must be done before setting rotation
  tft.begin();
  tft.fillScreen(ILI9340_BLACK);
  calibrate();  // No rotation!!
  button.initButton(&tft, 100, 100, 70, 40, ILI9340_DARKCYAN, ILI9340_BLUE, ILI9340_GREENYELLOW, "Clear", 2);
  button.drawButton();
}

static uint16_t prev_x = 0xffff, prev_y = 0xffff;

void loop() {
  pollWiFi();

  uint16_t x, y;
  if (touch.isTouching())
  {
    touch.getPosition(x, y);
    if (prev_x == 0xffff)
    {
      tft.drawPixel(x, y, ILI9340_BLUE);
    }
    else
    {
      tft.drawLine(prev_x, prev_y, x, y, ILI9340_BLUE);
    }
    prev_x = x;
    prev_y = y;
  }
  else
  {
    prev_x = prev_y = 0xffff;
  }

  button.press(button.contains(x, y)); // tell the button it is pressed

  // now we can ask the buttons if their state has changed
  if (button.justReleased())
  {
    tft.fillScreen(ILI9340_BLACK);
    button.drawButton(); // draw normal
  }

  if (button.justPressed())
  {
    button.drawButton(true); // draw invert!
  }
  delay(20);
}
