// Komunikace
#include <Arduino.h>
#include "comm.h"
#include "variables.h"

extern Variables vars;

void Comm::handle(void)
{

  while (_comms.available() > 0)
  {
    char c = _comms.read();

    switch (_ReceiveState)
    {
    case RS_STARTHUNT:
      if (';' == c)
      {
        _ReceiveState = RS_READNAME;
        _name = "";
        _value = "";
      }
    break;

    case RS_READNAME:
      if ('"' != c)
        _name += c;
      else
        _ReceiveState = RS_READVALUE;
    break;

    case RS_READVALUE:
      if ('"' != c)
        _value += c;
      else
      {
        _ReceiveState = RS_STARTHUNT;
        vars.setVal(_name.c_str(), _value.c_str());
      }
    break;

    default:
      _ReceiveState = RS_STARTHUNT;
    break;
    }
    
  }
}

void Comm::send(String name, String value)
{

  _comms.printf(";%s\"%s\"\r\n", name.c_str(), value.c_str());
}
