// Obsluha dynamickeho WWW serveru
// www.xpablo.cz
#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <Streaming.h>
#include <FS.h>
#include "variables.h"

extern ESP8266WebServer wwwserver;
extern Variables vars;

//holds the current upload
File fsUploadFile;

bool loadFromFS(String path)
{

  // Vyrobeni jmena indexove stranky
  if (path.endsWith("/"))
  {
    String index = path + "index.htm";
    if (SPIFFS.exists(index))
      path += "index.htm";
    else
      path += "index.shtml";
  }

  // Zjisteni skutecneho jmena souboru - prednost servirovani maji zaGzipovane soubory
  String pathWithGz = path + ".gz";
  String realPath = path;
  if (SPIFFS.exists(pathWithGz) || SPIFFS.exists(path))
    if (SPIFFS.exists(pathWithGz))
      realPath += ".gz";

  File dataFile = SPIFFS.open(realPath.c_str(), "r");
  if (!dataFile)
    return false;

  String dataType = "text/plain";
  if (path.endsWith(".htm")) dataType = "text/html";
  else if (path.endsWith(".css")) dataType = "text/css";
  else if (path.endsWith(".js")) dataType = "application/javascript";
  else if (path.endsWith(".png")) dataType = "image/png";
  else if (path.endsWith(".gif")) dataType = "image/gif";
  else if (path.endsWith(".jpg")) dataType = "image/jpeg";
  else if (path.endsWith(".ico")) dataType = "image/x-icon";
  else if (path.endsWith(".xml")) dataType = "text/xml";
  else if (path.endsWith(".pdf")) dataType = "application/pdf";
  else if (path.endsWith(".zip")) dataType = "application/zip";
  else if (path.endsWith(".gz")) dataType = "application/zip";
  else if (path.endsWith(".shtml"))
  {
    dataType = "text/html";
    String result;
    int lineNo = 1; // cislo zpracovavaneho radku

    while (dataFile.available())
    {
      String line = dataFile.readStringUntil('\n');

      if (line.startsWith("%!"))
      { // parametry skriptu
        line.remove(0, 2); // odstranime "%!"
        if (line.startsWith(":"))
        { // odesilani vnoreneho souboru
          line.remove(0, 1); // odstranime :
          line.trim(); // odstranime uvodni a koncove mezery
          File ef = SPIFFS.open(line.c_str(), "r");
          if (ef)
          {
            result += ef.readStringUntil(0xff);
            ef.close();
          }
          else
          {
            result += "<span style=\"color:red\">Missing include file: ";
            result += line;
            result += ".</span>";
          }
        }
        else if (line.startsWith("-"))
        { // zmena typu dokumentu
          line.remove(0, 1); // odstranime -
          line.trim(); // odstranime zbytecne mezery
          dataType = line; // nastavime novy typ vracenych dat (nejspis pujde o xml/json zmenu)
        }
        else if (line.startsWith("@"))
        { // odeslani stari promenne
          line.remove(0, 1); // odstranime @
          line.trim(); // odstranime zbytecne mezery
          uint32_t age = vars.getAge((char *)line.c_str());
          result += age;
        }
        else
        { // odesilani dynamicky generovaneho parametru
          line.trim(); // odstranime mezery a zustane jmeno parametru
          const char *val = vars.getVal((char *)line.c_str());
          if (NULL == val)
          {
            result += "<span style=\"color:red\">Undefined variable: ";
            result += line;
            result += ".</span>";
          }
          else
            result += val;
        }
      }
      else
      {
        result += line;
        result += "\n";
      }
      ++lineNo;
    }
    wwwserver.send(200, dataType, result);
    dataFile.close();
    return true;
  }

  if (wwwserver.hasArg("download"))
    dataType = "application/octet-stream";

  if (wwwserver.streamFile(dataFile, dataType) != dataFile.size())
  {
    //    DBG_OUTPUT_PORT.println("Sent less data than expected!");
  }

  dataFile.close();
  return true;
}

void handleDumpVariables(void)
{
  String result = "<html>\
<head>\
<style type=\"text/css\">\
table {\
color: #333;\
font-family: Helvetica, Arial, sans-serif;\
width: 640px;\
border-collapse:\
collapse; border-spacing: 0;\
}\
td, th { border: 1px solid #CCC; height: 30px; }\
th {\
background: #F3F3F3;\
font-weight: bold;\
}\
td {\
background: #FAFAFA;\
text-align: center;\
}\
</style>\
</head>\
<body><table>";
  char *name;
  char *value;
  uint32_t age;

  vars.getFirst(&name, &value, &age);

  while (NULL != name)
  {
    result += "<tr><td>";
    result += name;
    result += "</td><td>";
    result += value;
    result += "</td><td>";
    result += age;
    result += "</td></tr>";
    vars.getNext(&name, &value, &age);
  }

  result += "</table></body></html>";
  wwwserver.send(200, "text/html", result);
}

void handleNotFound()
{

  if (loadFromFS(wwwserver.uri()))
    return;

  String message = "File Not Found\r\n\r\n";
  message += "URI: ";
  message += wwwserver.uri();
  message += "\r\nMethod: ";
  message += (wwwserver.method() == HTTP_GET) ? "GET" : "POST";
  message += "\r\nArguments: ";
  message += wwwserver.args();
  message += "\r\n";

  for (uint8_t i = 0; i < wwwserver.args(); i++ )
  {
    message += " " + wwwserver.argName(i) + ": " + wwwserver.arg(i) + "\r\n";
  }
  wwwserver.send(404, "text/plain", message);
}

void handleFileUpload()
{
  if (wwwserver.uri() != "/edit")
    return;
  HTTPUpload& upload = wwwserver.upload();
  if (upload.status == UPLOAD_FILE_START)
  {
    String filename = upload.filename;
    if (!filename.startsWith("/"))
      filename = "/" + filename;
    fsUploadFile = SPIFFS.open(filename, "w");
    filename = String();
  } else if (upload.status == UPLOAD_FILE_WRITE)
  {
    if (fsUploadFile)
      fsUploadFile.write(upload.buf, upload.currentSize);
  } else if (upload.status == UPLOAD_FILE_END)
  {
    if (fsUploadFile)
      fsUploadFile.close();
  }
}

void handleFileDelete()
{
  if (wwwserver.args() == 0)
  {
    wwwserver.send(500, "text/plain", "BAD ARGS");
    return;
  }
  String path = wwwserver.arg(0);
  if (path == "/")
  {
    wwwserver.send(500, "text/plain", "BAD PATH");
    return;
  }
  if (!SPIFFS.exists(path))
  {
    wwwserver.send(404, "text/plain", "FileNotFound");
    return;
  }
  SPIFFS.remove(path);
  wwwserver.send(200, "text/plain", "");
  path = String();
}

void handleFileCreate()
{
  if (wwwserver.args() == 0)
  {
    wwwserver.send(500, "text/plain", "BAD ARGS");
    return;
  }
  String path = wwwserver.arg(0);
  if (path == "/")
  {
    wwwserver.send(500, "text/plain", "BAD PATH");
    return;
  }
  if (SPIFFS.exists(path))
  {
    wwwserver.send(500, "text/plain", "FILE EXISTS");
    return;
  }
  File file = SPIFFS.open(path, "w");
  if (file)
    file.close();
  else
  {
    wwwserver.send(500, "text/plain", "CREATE FAILED");
    return;
  }
  wwwserver.send(200, "text/plain", "");
  path = String();
}

void handleFileList()
{
  if (!wwwserver.hasArg("dir"))
  {
    wwwserver.send(500, "text/plain", "BAD ARGS");
    return;
  }

  String path = wwwserver.arg("dir");
  Dir dir = SPIFFS.openDir(path);
  path = String();

  String output = "[";
  while (dir.next())
  {
    File entry = dir.openFile("r");
    if (output != "[")
      output += ',';
    bool isDir = false;
    output += "{\"type\":\"";
    output += (isDir) ? "dir" : "file";
    output += "\",\"name\":\"";
    output += String(entry.name()).substring(1);
    output += "\"}";
    entry.close();
  }
  output += "]";
  
  wwwserver.send(200, "text/json", output);
}

void wsStart(void)
{
  // Spusteni weboveho serveru
  //list directory
  wwwserver.on("/list", HTTP_GET, handleFileList);
  //load editor
  wwwserver.on("/edit", HTTP_GET, []() {
    if (!loadFromFS("/edit.htm")) wwwserver.send(404, "text/plain", "FileNotFound");
  });
  //create file
  wwwserver.on("/edit", HTTP_PUT, handleFileCreate);
  //delete file
  wwwserver.on("/edit", HTTP_DELETE, handleFileDelete);
  //first callback is called after the request has ended with all parsed arguments
  //second callback handles file uploads at that location
  wwwserver.on("/edit", HTTP_POST, []() {
    wwwserver.send(200, "text/plain", "");
  }, handleFileUpload);
  wwwserver.on("/dav", handleDumpVariables);
  wwwserver.onNotFound(handleNotFound);
  wwwserver.begin(); // startujeme webovy server
}
// EOF

