// xPablo.cz C328R & ESP8266 Still Camera example
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <EEPROM.h>
#include <WiFiConfig.h>
//#include <ESP8266mDNS.h>
#include <WiFiUdp.h>
#include <ArduinoOTA.h>
#include <CameraC328R.h>
#include <SoftwareSerial.h>

#define FORCE_CONFIG_BUTTON_PIN 3
#define LED_PIN 13
#define PAGE_SIZE 256 //64
#define USB_BAUD 115200
#define CAMERA_BAUD 14400
#define DEBUG_OUT(a) {}
//#define DEBUG_OUT(a) Serial.print(a)

static const char SCRIPTID[] = __FILE__ " Compiled @" __DATE__ " " __TIME__;

SoftwareSerial mySerial(5, 4, 512);
CameraC328R camera(mySerial);
uint16_t pictureSizeCount = 0;
ESP8266WebServer wwwserver(80); // webovy server - pouzity je jak pro nastaveni ESP modulu pomoci WifiConfig, tak pro praci aplikace
String content;
WifiConfig wifi; // konfigurace ESP modulu
WiFiClient client; // klient pro odesilani obrazku

static void handleNotFound()
{
  String message = "File Not Found\r\n\r\n";
  message += "URI: ";
  message += wwwserver.uri();
  message += "\r\nMethod: ";
  message += (wwwserver.method() == HTTP_GET) ? "GET" : "POST";
  message += "\r\nArguments: ";
  message += wwwserver.args();
  message += "\r\n";

  for (uint8_t i = 0; i < wwwserver.args(); i++ )
  {
    message += " " + wwwserver.argName(i) + ": " + wwwserver.arg(i) + "\r\n";
  }
  wwwserver.send(404, "text/plain", message);
}

static void handleRoot(void)
{

  content = F("\
<html>\
  <head>\
    <meta http-equiv='refresh' content='600'/>\
    <title>ESP8266 C328R Camera </title>\
    <style>\
      body { background-color: #DFE2DB; font-family: Arial, Helvetica, Sans-Serif; Color: #191919; }\
    </style>\
  </head>\
  <body>\
    <h1>IP Still Camera with an ESP8266 and C328R</h1>\
    <p style=\"text-align:center;\"><img src=\"/image.jpg\"></p>\
  </body>\
</html>");
  wwwserver.send(200, F("text/html"), content);
}

/*
  This callback is called EVERY time a JPEG data packet is received.
*/
static void getWebPicture_callback( uint16_t pictureSize, uint16_t packageSize, uint16_t packageCount, byte* package)
{

  if (0 == packageCount)
  {
    char httphdr[512];

    snprintf(httphdr, sizeof(httphdr),
             "HTTP/1.1 200 OK\r\n\
Connection: close\r\n\
Content-Length: %i\r\n\
Content-Type: image/jpeg\r\n\
\r\n",
             pictureSize);
    client.print(httphdr);
  }
  client.write((unsigned char *)package, packageSize);
  DEBUG_OUT(F("."));
  delay(0);
}

static void image(void)
{

  if ( !camera.sync() )
  {
    DEBUG_OUT(F("Sync failed.\r\n"));
    return;
  }
  if ( !camera.initial( CameraC328R::CT_JPEG, CameraC328R::PR_160x120, CameraC328R::JR_640x480 ) )
  {
    DEBUG_OUT(F("Initial failed.\r\n"));
    return;
  }
  if ( !camera.setPackageSize(PAGE_SIZE))
  {
    DEBUG_OUT(F("Package size failed.\r\n"));
    return;
  }
  if ( !camera.setLightFrequency(CameraC328R::FT_50Hz))
  {
    DEBUG_OUT(F("Light frequency failed.\r\n"));
    return;
  }
  if ( !camera.snapshot(CameraC328R::ST_COMPRESSED, 0))
  {
    DEBUG_OUT(F("Snapshot failed.\r\n"));
    return;
  }
  client = wwwserver.client();
  client.setNoDelay(true);

  pictureSizeCount = 0;
  if (!camera.getJPEGPicture(CameraC328R::PT_JPEG, PROCESS_DELAY, &getWebPicture_callback))
  {
    DEBUG_OUT(F("Get JPEG failed.\r\n"));
    return;
  }
}

void wcb(wificonfigstate_t state)
{
  switch (state)
  {
    case WCS_CONNECTSTART:
      DEBUG_OUT(F("Starting connect...\r\n"));
      break;

    case WCS_CONNECTING:
      break;

    case WCS_CONFIGSTART:
      DEBUG_OUT(F("Starting config...\r\n"));
      break;

    case WCS_CONFIGWAIT:
      break;
  }
}

/*
  This callback is called EVERY time a JPEG data packet is received.
*/
void getJPEGPicture_callback( uint16_t pictureSize, uint16_t packageSize, uint16_t packageCount, byte* package)
{
  // packageSize is the size of the picture part of the package

  DEBUG_OUT(F("Got package #"));
  DEBUG_OUT(packageCount);
  DEBUG_OUT(F("\r\n"));
}

void setup()
{
  EEPROM.begin(512); // zahajujeme praci s EEPROM
  pinMode(FORCE_CONFIG_BUTTON_PIN, INPUT_PULLUP); // RXD slouzi jako vstup tlacitka
  delay(10);
  int force = digitalRead(FORCE_CONFIG_BUTTON_PIN);
  Serial.begin(USB_BAUD);
  DEBUG_OUT(F("Starting up...\r\n"));
  mySerial.begin(CAMERA_BAUD);
  wifi.begin(0, force, wcb); // startujeme pripojeni
  DEBUG_OUT(F("Our IP: "));
  DEBUG_OUT(getOurIP());
  DEBUG_OUT(F("\r\n"));

  wwwserver.on("/", handleRoot);
  wwwserver.on("/image.jpg", image);
  wwwserver.begin(); // startujeme webovy server

  //  ArduinoOTA.setHostname();
  ArduinoOTA.onStart([]() {
    DEBUG_OUT(F("Start\r\n"));
  });
  ArduinoOTA.onEnd([]() {
    DEBUG_OUT(F("End\r\n"));
  });
  //  ArduinoOTA.onProgress([](unsigned int progress, unsigned int total) {
  //    DEBUG_OUT("Progress: %u%%\r\n", (progress / (total / 100)));
  //  });
  ArduinoOTA.onError([](ota_error_t error) {
    DEBUG_OUT(F("Error["));
    DEBUG_OUT(error);
    DEBUG_OUT(F("]: "));
    switch (error)
    {
      case OTA_AUTH_ERROR:
        DEBUG_OUT(F("Auth Failed\r\n"));
        break;

      case OTA_BEGIN_ERROR:
        DEBUG_OUT(F("Begin Failed\r\n"));
        break;

      case OTA_CONNECT_ERROR:
        DEBUG_OUT(F("Connect Failed\r\n"));
        break;

      case OTA_RECEIVE_ERROR:
        DEBUG_OUT(F("Receive Failed\r\n"));
        break;

      case OTA_END_ERROR:
        DEBUG_OUT(F("End Failed\r\n"));
        break;

      default:
        DEBUG_OUT(F("\r\n"));
    }
  });
  ArduinoOTA.begin();
}

void loop()
{
  if (Serial.available())
  {
    Serial.println("Taking snapshot...");
    while (Serial.read() != -1)
      ;
    //   digitalWrite( LED_PIN, HIGH );
    Serial.println("Syncing camera...");
    if ( !camera.sync() )
    {
      Serial.println( "Sync failed." );
      return;
    }
    Serial.println("Initializing camera...");
    if ( !camera.initial( CameraC328R::CT_JPEG, CameraC328R::PR_160x120, CameraC328R::JR_640x480 ) )
    {
      Serial.println( "Initial failed." );
      return;
    }
    Serial.println("Setting package size...");
    if ( !camera.setPackageSize(PAGE_SIZE))
    {
      Serial.println( "Package size failed." );
      return;
    }
    Serial.println("Setting light frequency...");
    if ( !camera.setLightFrequency(CameraC328R::FT_50Hz))
    {
      Serial.println( "Light frequency failed." );
      return;
    }
    Serial.println("Taking snapshot...");
    if ( !camera.snapshot(CameraC328R::ST_COMPRESSED, 0))
    {
      Serial.println("Snapshot failed.");
      return;
    }
    Serial.println("Reading data...");
    pictureSizeCount = 0;
    if (!camera.getJPEGPicture(CameraC328R::PT_JPEG, PROCESS_DELAY, &getJPEGPicture_callback))
    {
      Serial.println("Get JPEG failed.");
      return;
    }
  }
  wwwserver.handleClient(); // osetrujeme praci serveru
  ArduinoOTA.handle();
}

