
#define ILI9340_GREY 0x2104 // Dark grey 16 bit colour

//#define RADIUS_BIG 84

#define RADIUS_BIG 70

// #########################################################################
// Return a 16 bit rainbow colour
// #########################################################################
static unsigned int rainbow(byte value)
{
  // Value is expected to be in range 0-127
  // The value is converted to a spectrum colour from 0 = blue through to 127 = red

  byte red = 0; // Red is the top 5 bits of a 16 bit colour value
  byte green = 0;// Green is the middle 6 bits
  byte blue = 0; // Blue is the bottom 5 bits

  byte quadrant = value / 32;

  if (quadrant == 0)
  {
    blue = 31;
    green = 2 * (value % 32);
    red = 0;
  }
  if (quadrant == 1)
  {
    blue = 31 - (value % 32);
    green = 63;
    red = 0;
  }
  if (quadrant == 2)
  {
    blue = 0;
    green = 63;
    red = value % 32;
  }
  if (quadrant == 3)
  {
    blue = 0;
    green = 63 - 2 * (value % 32);
    red = 31;
  }
  return (red << 11) + (green << 5) + blue;
}

// #########################################################################
// Return a value in range -1 to +1 for a given phase angle in degrees
// #########################################################################
static float sineWave(int phase)
{

  return sin(phase * 0.0174532925);
}

void ringMeter_init(meter_t *meter, int vmin, int vmax, int x, int y, int r, char *units, int scheme, int split)
{

	meter->vmin = vmin;
	meter->vmax = vmax;
	meter->xpos = x;
	meter->ypos = y;
  meter->radius = r;
	meter->units = units;
	meter->colourScheme = scheme;
	meter->split = split;
}


void ringMeter_draw(meter_t *meter, float value)
{
  // Minimum value of r is about 52 before value text intrudes on ring
  // drawing the text first is an option

	int x = meter->xpos + meter->radius;
	int y = meter->ypos + meter->radius;

	int w = meter->radius / 4;    // Width of outer ring is 1/4 of radius
  
  int angle = 150;  // Half the sweep angle of meter (300 degrees)

  int text_colour = 0; // To hold the text colour

  int v = map((int)value, meter->vmin, meter->vmax, -angle, angle); // Map the value to an angle v

  byte seg = 5; // Segments are 5 degrees wide = 60 segments for 300 degrees
  byte inc;

  if (meter->split)
    inc = 10; // Draw segments every 10 degree for segmented ring
  else
    inc = 5; // Draw segments every 5 degrees

  // Draw colour blocks every inc degrees
  for (int i = -angle; i < angle; i += inc)
  {

    // Choose colour from scheme
    int colour = 0;
    switch (meter->colourScheme)
	{
      case SCHEME_ALL_RED:
		colour = ILI9340_RED;
	  break;

      case SCHEME_ALL_GREEN:
        colour = ILI9340_GREEN;
	  break;

      case SCHEME_ALL_BLUE:
		colour = ILI9340_BLUE;
	  break;

      case SCHEME_BLUE_TO_RED:
		colour = rainbow(map(i, -angle, angle, 0, 127));
	  break; // Full spectrum blue to red

      case SCHEME_GREEN_TO_RED:
		colour = rainbow(map(i, -angle, angle, 63, 127));
	  break; // Green to red (high temperature etc)

      case SCHEME_RED_TO_GREEN:
		colour = rainbow(map(i, -angle, angle, 127, 63));
	  break; // Red to green (low battery etc)

      default:
		colour = ILI9340_BLUE;
	  break; // Fixed colour
    }

    // Calculate pair of coordinates for segment start
    float sx = cos((i - 90) * 0.0174532925);
    float sy = sin((i - 90) * 0.0174532925);
    uint16_t x0 = sx * (meter->radius - w) + x;
    uint16_t y0 = sy * (meter->radius - w) + y;
    uint16_t x1 = sx * meter->radius + x;
    uint16_t y1 = sy * meter->radius + y;

    // Calculate pair of coordinates for segment end
    float sx2 = cos((i + seg - 90) * 0.0174532925);
    float sy2 = sin((i + seg - 90) * 0.0174532925);
    int x2 = sx2 * (meter->radius - w) + x;
    int y2 = sy2 * (meter->radius - w) + y;
    int x3 = sx2 * meter->radius + x;
    int y3 = sy2 * meter->radius + y;

    if (i < v) { // Fill in coloured segments with 2 triangles
      tft.fillTriangle(x0, y0, x1, y1, x2, y2, colour);
      tft.fillTriangle(x1, y1, x2, y2, x3, y3, colour);
      text_colour = colour; // Save the last colour drawn
    }
    else // Fill in blank segments
    {
      tft.fillTriangle(x0, y0, x1, y1, x2, y2, ILI9340_GREY);
      tft.fillTriangle(x1, y1, x2, y2, x3, y3, ILI9340_GREY);
    }
  }

  // Convert value to a string
  char buf[10];
  byte len = 4;
  if (value > 999)
	len = 5;
  dtostrf(value, len, 0, buf);

  // Set the text colour to default
  tft.setTextColor(ILI9340_WHITE, ILI9340_BLACK);
  // Uncomment next line to set the text colour to the last segment value!
  // tft.setTextColor(text_colour, ILI9341_BLACK);

  // Print value, if the meter is large then use big font 6, othewise use 4
  if (meter->radius > RADIUS_BIG)
    tft.drawCentreString(buf, x - 5, y - 20, 6); // Value in middle
  else
    tft.drawCentreString(buf, x - 5, y - 20, 4); // Value in middle

  // Print units, if the meter is large then use big font 4, othewise use 2
  tft.setTextColor(ILI9340_WHITE, ILI9340_BLACK);
  if (meter->radius > RADIUS_BIG)
    tft.drawCentreString(meter->units, x, y + 30, 4); // Units display
  else
    tft.drawCentreString(meter->units, x, y + 5, 2); // Units display
  // Calculate and return right hand side x coordinate
//  return x + r;

}

