 
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <EEPROM.h>
#include <WiFiUDP.h>
#include <SPI.h>
#include <Adafruit_GFX_AS8.h>
#include <Adafruit_ILI9340_AS8.h>
#include "meter.h"
#include <WifiConfig.h>
extern "C" {
  #include "nsscanf.h"
}

#define _cs 5
#define _dc 4
#define _rst 15

// teplota
meter_t m1 =
{
	.vmin = -30,
	.vmax = 50,
	.xpos = 0,
	.ypos = 20,
	.radius = 75,
	.units = "C",
	.colourScheme = SCHEME_BLUE_TO_RED,
	.split = 0
};

// vlhkost
meter_t m2 =
{
  .vmin = 0,
  .vmax = 100,
  .xpos = 170,
  .ypos = 20,
  .radius = 75,
  .units = "%",
  .colourScheme = SCHEME_ALL_RED,
  .split = 0
};

// rosny bod
meter_t m3 =
{
  .vmin = -10,
  .vmax = 30,
  .xpos = 115,
  .ypos = 150,
  .radius = 45,
//  .units = "\xB0C",
  .units = "C",
  .colourScheme = SCHEME_ALL_GREEN,
  .split = 1
};

ESP8266WebServer wwwserver(80); // webovy server - pouzity je jak pro nastaveni ESP modulu pomoci WifiConfig, tak pro praci aplikace
WifiConfig wifi; // konfigurace ESP modulu

// Use hardware SPI
Adafruit_ILI9340_AS8 tft = Adafruit_ILI9340_AS8(_cs, _dc, _rst);

WiFiUDP Udp;
// Multicast declarations
IPAddress ipMulti(239, 0, 0, 57);
unsigned int portMulti = 5566;      // local port to listen on
byte packetBuffer[512]; //buffer to hold incoming and outgoing packets
char ReplyBuffer[] = ""; // a null

enum
{
  SM_FIRST_DATA_WAIT = 0, // cekani na prvni data
  SM_NEXT_DATA_WAIT, // cekani na dalsi data
}sysmode = SM_FIRST_DATA_WAIT;

void wccb(wificonfigstate_t state)
{

  switch (state)
  {
  case WCS_CONNECTSTART:
  break;

  case WCS_CONNECTING:
  break;

  case WCS_CONFIGSTART:
    tft.println("Connect failed - starting config AP...");
  break;

  case WCS_CONFIGWAIT:
  break;
  }
}

float getDewPoint(float temperature, float humidity)
{
  float fH = (log10(humidity) - 2) / 0.4343 + (17.62 * temperature) / (243.12 + temperature);
  return 243.12 * fH / (17.62 - fH); // this is the dew point in Celsius
}
void setup()
{

  Serial.begin(9600);
  while (!Serial);
  
  tft.begin();
  tft.setRotation(1);
  tft.fillScreen(ILI9340_BLACK);
  tft.setCursor(0, 0);
  tft.setTextColor(ILI9340_WHITE);
//  tft.setTextSize(2);
  tft.println("Trying to start WiFi...");

  EEPROM.begin(512); // zahajujeme praci s EEPROM
  pinMode(3, INPUT_PULLUP); // RXD slouzi jako vstup tlacitka
  wifi.begin(0, digitalRead(3)); // startujeme pripojeni 

  tft.println("Connected!");
  tft.println(getOurIP());
  tft.println("Waiting for data...");

  while (!Udp.beginMulticast(WiFi.localIP(),  ipMulti, portMulti))
  {
	Serial.print("*");
    delay(250);
  }
}

void loop(void)
{

//  int i = WiFi.status();
  
  int noBytes = Udp.parsePacket();
  if (noBytes)
  {
    Udp.read(packetBuffer,noBytes); // read the packet into the buffer
    float temperature;
    float humidity;
    int id;

    nsscanf((char *)&packetBuffer, ":%i;%f;%f;", &id, &temperature, &humidity);
    switch (sysmode)
    {
    case SM_FIRST_DATA_WAIT:
      tft.fillScreen(ILI9340_BLACK);
	  tft.drawCentreString("Teplota", 75, 0, 2); // Units display 
	  tft.drawCentreString("Vlhkost", 170 + 75, 0, 2); // Units display 
//    tft.setTextSize(1);
      ringMeter_draw(&m1, temperature);
      ringMeter_draw(&m2, humidity);
      ringMeter_draw(&m3, getDewPoint(temperature, humidity));
      sysmode = SM_NEXT_DATA_WAIT;
    break;

    case SM_NEXT_DATA_WAIT:
      ringMeter_draw(&m1, temperature);
      ringMeter_draw(&m2, humidity);
      ringMeter_draw(&m3, getDewPoint(temperature, humidity));
    break;
    }
    // display the packet contents in HEX
    for (int i=1;i<=noBytes;i++){
      Serial.print(packetBuffer[i-1],HEX);
      if (i % 32 == 0){
        Serial.println();
      }
      else Serial.print(' ');
    } // end for
    Serial.println();
//    Udp.flush();
    Udp.beginPacket(WiFi.localIP(), Udp.remotePort()); // send a reply, to the IP address and port that sent us the packet we received
    Udp.write(ReplyBuffer); // should not be necessary but it seems that the ESP8266
    Udp.endPacket(); // is stablized by the inclusion of the send
  } // end if
}


unsigned long testText() {
  tft.fillScreen(ILI9340_BLACK);
  unsigned long start = micros();
  tft.setCursor(0, 0);
  tft.setTextColor(ILI9340_WHITE);  tft.setTextSize(1);
  tft.println("Hello World!");
  tft.setTextColor(ILI9340_YELLOW); tft.setTextSize(2);
  tft.println(1234.56);
  tft.setTextColor(ILI9340_RED);    tft.setTextSize(3);
  tft.println(0xDEADBEEF, HEX);
  tft.println();
  tft.setTextColor(ILI9340_GREEN);
  tft.setTextSize(5);
  tft.println("Groop");
  tft.setTextSize(2);
  tft.println("I implore thee,");
  tft.setTextSize(1);
  tft.println("my foonting turlingdromes.");
  tft.println("And hooptiously drangle me");
  tft.println("with crinkly bindlewurdles,");
  tft.println("Or I will rend thee");
  tft.println("in the gobberwarts");
  tft.println("with my blurglecruncheon,");
  tft.println("see if I don't!");
  return micros() - start;
}
// EOF
