#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
#include <WiFiUDP.h>
#include <DHT.h>
#include <EEPROM.h>
#include <WifiConfig.h>
#include <interval.h>
#include <espnbns.h>

#define DHTTYPE DHT22
#define DHTPIN  2
#define FORCE_CONFIG_BUTTON_PIN 3 // pin pro tlacitko na vynucenou rekonfiguraci (RXD)

// Definice obsazeni EEPROM
#define elementSize(type, element) sizeof(((type *)0)->element)
typedef struct
{
  wificonfigarea_t wc; // oblast, vyhrazena pro konfiguraci WiFi
  char apiKey[33]; // retezec, obsahujici APIKEY pro ThingSpeak
  char server[65]; // retezec, obsahujici adresu Thingspeak serveru
  char field[65]; // jmeno datapointu, do ktereho je ukladana teplota
  char periode[32]; // perioda ukladani dat [s]
}eepromdata;

WifiConfig wifi; // konfigurace ESP modulu
NBNS nbns;

ESP8266WebServer wwwserver(80); // webovy server
 
// Initialize DHT sensor 
// NOTE: For working with a faster than ATmega328p 16 MHz Arduino chip, like an ESP8266,
// you need to increase the threshold for cycle counts considered a 1 or 0.
// You can do this by passing a 3rd parameter for this threshold.  It's a bit
// of fiddling to find the right value, but in general the faster the CPU the
// higher the value.  The default for a 16mhz AVR is a value of 6.  For an
// Arduino Due that runs at 84mhz a value of 30 works.
// This is for the ESP8266 processor on ESP-01 
//DHT dht(DHTPIN, DHTTYPE, 11); // 11 works fine for ESP8266
DHT dht(DHTPIN, DHTTYPE, 15); // value from WiFiWebServer-WeatherSensor.ino for DHT11...
 
float humidity, temp_f;  // Values read from sensor

Interval measurement; // interval mezi jednotlivymi merenimi
String nbnsname;
WiFiUDP udp;
// Multicast declarations
IPAddress ipMulti(239, 0, 0, 57);
unsigned int portMulti = 5566;      // local port to listen on

void wcb(wificonfigstate_t state)
{
  switch (state)
  {
  case WCS_CONNECTSTART:
    Serial.println("Starting connect...");
  break;
  
  case WCS_CONNECTING:
  break;
  
  case WCS_CONFIGSTART:
    Serial.println("Starting config...");
  break;
  
  case WCS_CONFIGWAIT:
  break;
  }
}

void setup(void)
{

  EEPROM.begin(512); // zahajujeme praci s EEPROM
  pinMode(FORCE_CONFIG_BUTTON_PIN, INPUT_PULLUP); // RXD slouzi jako vstup tlacitka
  delay(10);
  int force = digitalRead(FORCE_CONFIG_BUTTON_PIN);
  Serial.begin(9600);
  wifi.begin(offsetof(eepromdata, wc), force, wcb); // startujeme pripojeni 

  Serial.println(getOurIP());
  
  dht.begin(); // inicializujeme senzor
 
  nbnsname = getEEPROMString(offsetof(wificonfigarea_t, devname), elementSize(wificonfigarea_t, devname));
  if (nbnsname.length() > 0)
  {
    nbns.begin(nbnsname.c_str());
  } 
}
 
void loop(void)
{

  nbns.poll();
  gettemperature();
} 
 
void gettemperature()
{

  if (measurement.expired())
  {
//    udp.flush();
    // Reading temperature for humidity takes about 250 milliseconds!
    // Sensor readings may also be up to 2 seconds 'old' (it's a very slow sensor)
    humidity = dht.readHumidity();          // Read humidity (percent)
    temp_f = dht.readTemperature(false);     // Read temperature as Celsius
    // Check if any reads failed and exit early (to try again).
    if (isnan(humidity) || isnan(temp_f))
    {
      Serial.println("Failed to read from DHT sensor!");
    }
	  else
	  {
		  String result;
		  result = ":7777;";
		  result += temp_f;
		  result += ";";
		  result += humidity;
		  result += ";";
		  udp.beginPacket(ipMulti, portMulti);
		  udp.print(result);
		  udp.endPacket();
      Serial.println("Data sent...");
	  }
    measurement.set(5000); // nastavime novy interval mereni
  }
}
// EOF

