#include <Arduino.h>

// Obsluha weboveho serveru
#ifdef USE_SPIFFS
String getContentType(String filename)
{
  if (www.hasArg("download")) return F("application/octet-stream");
  else if (filename.endsWith(".htm")) return F("text/html");
  else if (filename.endsWith(".html")) return F("text/html");
  else if (filename.endsWith(".css")) return F("text/css");
  else if (filename.endsWith(".js")) return F("application/javascript");
  else if (filename.endsWith(".png")) return F("image/png");
  else if (filename.endsWith(".gif")) return F("image/gif");
  else if (filename.endsWith(".jpg")) return F("image/jpeg");
  else if (filename.endsWith(".ico")) return F("image/x-icon");
  else if (filename.endsWith(".xml")) return F("text/xml");
  else if (filename.endsWith(".pdf")) return F("application/x-pdf");
  else if (filename.endsWith(".zip")) return F("application/x-zip");
  else if (filename.endsWith(".gz")) return F("application/x-gzip");
  return F("text/plain");
}

bool handleFileRead(String path)
{
  if (path.endsWith("/")) path += F("index.htm");
  String contentType = getContentType(path);
  String pathWithGz = path + ".gz";
  if (SPIFFS.exists(pathWithGz) || SPIFFS.exists(path))
  {
    if (SPIFFS.exists(pathWithGz))
      path += ".gz"; // prioritu ma komprimovany obsah
    File file = SPIFFS.open(path, "r");
    size_t sent = www.streamFile(file, contentType);
    file.close();
    return true;
  }
  return false;
}
#endif

void handleNotFound()
{
  String message = F("File Not Found\r\n\r\nURI:");
  message += www.uri();
  message += F("\r\nMethod: ");
  message += (www.method() == HTTP_GET) ? "GET" : "POST";
  message += F("\r\nArguments: ");
  message += www.args();
  message += F("\r\n");

  for (int i = 0; i < www.args(); i++ )
  {
    message += " " + www.argName(i) + ": " + www.arg(i) + "\r\n";
  }
  www.send(404, "text/plain", message);
}
