/***************************************************
  This is our library for the Adafruit  ILI9340 Breakout and Shield
  ----> http://www.adafruit.com/products/1651

  Check out the links above for our tutorials and wiring diagrams
  These displays use SPI to communicate, 4 or 5 pins are required to
  interface (RST is optional)
  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!

  Written by Limor Fried/Ladyada for Adafruit Industries.
  MIT license, all text above must be included in any redistribution
 ****************************************************/

#ifndef _ADAFRUIT_ILI9340H_
#define _ADAFRUIT_ILI9340H_

#if ARDUINO >= 100
 #include "Arduino.h"
 #include "Print.h"
#else
 #include "WProgram.h"
#endif
#include <Adafruit_GFX_AS8.h>
#ifdef ESP8266
#include <pgmspace.h>
#else
#include <avr/pgmspace.h>
#endif

#define ILI9340_TFTWIDTH  240
#define ILI9340_TFTHEIGHT 320

#define ILI9340_NOP     0x00
#define ILI9340_SWRESET 0x01
#define ILI9340_RDDID   0x04
#define ILI9340_RDDST   0x09

#define ILI9340_SLPIN   0x10
#define ILI9340_SLPOUT  0x11
#define ILI9340_PTLON   0x12
#define ILI9340_NORON   0x13

#define ILI9340_RDMODE  0x0A
#define ILI9340_RDMADCTL  0x0B
#define ILI9340_RDPIXFMT  0x0C
#define ILI9340_RDIMGFMT  0x0A
#define ILI9340_RDSELFDIAG  0x0F

#define ILI9340_INVOFF  0x20
#define ILI9340_INVON   0x21
#define ILI9340_GAMMASET 0x26
#define ILI9340_DISPOFF 0x28
#define ILI9340_DISPON  0x29

#define ILI9340_CASET   0x2A
#define ILI9340_PASET   0x2B
#define ILI9340_RAMWR   0x2C
#define ILI9340_RAMRD   0x2E

#define ILI9340_PTLAR   0x30
#define ILI9340_MADCTL  0x36


#define ILI9340_MADCTL_MY  0x80
#define ILI9340_MADCTL_MX  0x40
#define ILI9340_MADCTL_MV  0x20
#define ILI9340_MADCTL_ML  0x10
#define ILI9340_MADCTL_RGB 0x00
#define ILI9340_MADCTL_BGR 0x08
#define ILI9340_MADCTL_MH  0x04

#define ILI9340_PIXFMT  0x3A

#define ILI9340_FRMCTR1 0xB1
#define ILI9340_FRMCTR2 0xB2
#define ILI9340_FRMCTR3 0xB3
#define ILI9340_INVCTR  0xB4
#define ILI9340_DFUNCTR 0xB6

#define ILI9340_PWCTR1  0xC0
#define ILI9340_PWCTR2  0xC1
#define ILI9340_PWCTR3  0xC2
#define ILI9340_PWCTR4  0xC3
#define ILI9340_PWCTR5  0xC4
#define ILI9340_VMCTR1  0xC5
#define ILI9340_VMCTR2  0xC7

#define ILI9340_RDID1   0xDA
#define ILI9340_RDID2   0xDB
#define ILI9340_RDID3   0xDC
#define ILI9340_RDID4   0xDD

#define ILI9340_GMCTRP1 0xE0
#define ILI9340_GMCTRN1 0xE1 

// Color definitions
#define ILI9340_BLACK       0x0000      /*   0,   0,   0 */
#define ILI9340_NAVY        0x000F      /*   0,   0, 128 */
#define ILI9340_DARKGREEN   0x03E0      /*   0, 128,   0 */
#define ILI9340_DARKCYAN    0x03EF      /*   0, 128, 128 */
#define ILI9340_MAROON      0x7800      /* 128,   0,   0 */
#define ILI9340_PURPLE      0x780F      /* 128,   0, 128 */
#define ILI9340_OLIVE       0x7BE0      /* 128, 128,   0 */
#define ILI9340_LIGHTGREY   0xC618      /* 192, 192, 192 */
#define ILI9340_DARKGREY    0x7BEF      /* 128, 128, 128 */
#define ILI9340_BLUE        0x001F      /*   0,   0, 255 */
#define ILI9340_GREEN       0x07E0      /*   0, 255,   0 */
#define ILI9340_CYAN        0x07FF      /*   0, 255, 255 */
#define ILI9340_RED         0xF800      /* 255,   0,   0 */
#define ILI9340_MAGENTA     0xF81F      /* 255,   0, 255 */
#define ILI9340_YELLOW      0xFFE0      /* 255, 255,   0 */
#define ILI9340_WHITE       0xFFFF      /* 255, 255, 255 */
#define ILI9340_ORANGE      0xFD20      /* 255, 165,   0 */
#define ILI9340_GREENYELLOW 0xAFE5      /* 173, 255,  47 */
#define ILI9340_PINK        0xF81F

//#define ILI9340_USE_DIGITAL_WRITE
//#define ILI9340_USE_NO_CS
#ifdef ESP8266
//not working
//#define ILI9340_USE_HW_CS
#endif

class Adafruit_ILI9340_AS8 : public Adafruit_GFX_AS8 {

 public:
#ifndef ESP8266
  Adafruit_ILI9340_AS8(int8_t _CS, int8_t _DC, int8_t _MOSI, int8_t _SCLK,
		   int8_t _RST, int8_t _MISO);
#endif
#if defined(USE_HW_CS) || defined(USE_NO_CS)
  Adafruit_ILI9340_AS8(int8_t _DC, int8_t _RST = -1);
#else
  Adafruit_ILI9340_AS8(int8_t _CS, int8_t _DC, int8_t _RST = -1);
#endif
  void     begin(void),
           setAddrWindow(int16_t x0, int16_t y0, int16_t x1, int16_t y1),
           pushColor(uint16_t color),
           fillScreen(uint16_t color),
           drawPixel(int16_t x, int16_t y, uint16_t color),
		   drawPixel(uint16_t color),
			drawStart(),
			drawEnd(),
           drawFastVLine(int16_t x, int16_t y, int16_t h, uint16_t color),
           drawFastHLine(int16_t x, int16_t y, int16_t w, uint16_t color),
           fillRect(int16_t x, int16_t y, int16_t w, int16_t h,
             uint16_t color),
           setRotation(uint8_t r),
           invertDisplay(boolean i);
  uint16_t color565(uint8_t r, uint8_t g, uint8_t b);

  void  commandList(uint8_t *addr);

  /* These are not for current use, 8-bit protocol only! */
   uint8_t  readdata(void),
     readcommand8(uint8_t reg, uint8_t index = 0);

   void  writecommand(uint8_t c);
   void  writedata(uint8_t d);
   void  writedata(uint8_t * data, uint8_t size);
   void  writeCmdData(uint8_t cmd, uint8_t * data, uint8_t size);


   uint16_t getHeight(void);
   uint16_t getWidth(void);

   void area_update_start(uint32_t x, uint32_t y, uint32_t w, uint32_t h);
   void area_update_data(uint8_t *data, uint32_t pixel);
   void area_update_end(void);
 private:

  uint8_t  spiread(void);


#ifdef ESP8266
  inline void spiwrite(uint8_t data);
  inline void spiwrite16(uint16_t data);
  inline void spiwriteBytes(uint8_t * data, uint32_t size);
  inline void spiwritePattern(uint8_t * data, uint8_t size, uint32_t repeat);

  inline void setAddrWindow_(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1);
#else
  void spiwrite(uint8_t);
  void spiwrite16(uint16_t data);
  void spiwriteBytes(uint8_t * data, uint8_t size);
  void spiwritePattern(uint8_t * data, uint8_t size, uint8_t repeat);
  void setAddrWindow_(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1);
#endif

  inline void spiCsHigh(void);
  inline void spiCsLow(void);
  inline void spiDcHigh(void);
  inline void spiDcLow(void);

  uint8_t  tabcolor;
#ifndef ESP8266
  boolean  hwSPI;
#endif
#if defined (__AVR__) || defined(TEENSYDUINO)
  uint8_t mySPCR;
  volatile uint8_t *mosiport, *clkport, *dcport, *rsport, *csport;
  int8_t  _cs, _dc, _rst, _mosi, _miso, _sclk;
  uint8_t  mosipinmask, clkpinmask, cspinmask, dcpinmask;
#elif defined (__arm__)
    volatile RwReg *mosiport, *clkport, *dcport, *rsport, *csport;
    uint32_t  _cs, _dc, _rst, _mosi, _miso, _sclk;
    uint32_t  mosipinmask, clkpinmask, cspinmask, dcpinmask;
#elif defined (ESP8266)
#ifndef USE_HW_CS
    int8_t  _cs;
    uint32_t _csMask;
#endif
    int8_t  _dc, _rst;
    uint32_t _dcMask, _rstMask;
#endif
};

#endif
