//#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <EEPROM.h>
#include <WiFiUdp.h>
#include <ArduinoOTA.h>
#include <ESP8266FtpServer.h>
//#include <SoftwareSerial.h>
#include <interval.h>
#include <espnbns.h>
#include "libraries/WiFiConfig/WiFiConfig.h"
#include "variables.h"
#include "cgiws.h"
#include "libraries/pzem/pzem.h"

#define FORCE_CONFIG_BUTTON_PIN 3
#define LED_PIN 13
#define USB_BAUD 9600
#define DEBUG_OUT(a) {}
//#define DEBUG_OUT(a) Serial.print(a)

#define __INOVERSION__ __FILE__ " Compiled @" __DATE__ " " __TIME__

// Definice obsazeni EEPROM
#define elementSize(type, element) sizeof(((type *)0)->element)
typedef struct
{
  wificonfigarea_t wc; // oblast, vyhrazena pro konfiguraci WiFi
} eepromdata_t;

//PZEM004T pzem(5,4);  // RX,TX
//SoftwareSerial ss(5, 4);
//Pzem meter(ss);
Pzem meter(Serial);
//IPAddress ip(192,168,1,1);
FtpServer ftpSrv;   //set #define FTP_DEBUG in ESP8266FtpServer.h to see ftp verbose on serial
ESP8266WebServer wwwserver(80); // webovy server
NBNS nbns; // Netbios (xPablo.cz)
Variables vars; // komunikacni promenne (xPablo.cz)
Interval measure; // merici interval (xPablo.cz)

char tempStrBuff[256]; // pomocny buffer pro navratove hodnoty z promennych, ovladanych volanim

static char *upTimeStr(void)
{
    int uptimesec = millis() / 1000;
    int uptimemin = uptimesec / 60;
    int uptimehr  = uptimemin / 60;
    int uptimeday = uptimehr  / 24;

    uptimesec %= 60;
    uptimemin %= 60;
    uptimehr  %= 24;

    snprintf(tempStrBuff, sizeof(tempStrBuff), "%d Days, %02d:%02d:%02d", uptimeday, uptimehr, uptimemin, uptimesec );
    return tempStrBuff;
}

static char *getFreeHeap(void)
{

  snprintf(tempStrBuff, sizeof(tempStrBuff), "%d", ESP.getFreeHeap());
  return tempStrBuff;
}

void ICACHE_FLASH_ATTR wcb(wificonfigstate_t state)
{

  switch (state)
  {
    case WCS_CONNECTSTART:
      DEBUG_OUT(F("Starting connect...\r\n"));
      break;

    case WCS_CONNECTING:
      break;

    case WCS_CONFIGSTART:
      DEBUG_OUT(F("Starting config...\r\n"));
      break;

    case WCS_CONFIGWAIT:
      break;
  }
}

void ICACHE_FLASH_ATTR setup(void)
{
  WiFiConfig wifi; // konfigurace ESP modulu (xPablo.cz)

  EEPROM.begin(512); // zahajujeme praci s EEPROM
  pinMode(FORCE_CONFIG_BUTTON_PIN, INPUT_PULLUP); // RXD slouzi jako vstup tlacitka
  delay(10);
  int force = digitalRead(FORCE_CONFIG_BUTTON_PIN);
  Serial.begin(USB_BAUD);
  DEBUG_OUT(F("\r\nStarting up...\r\n"));
  wifi.begin(0, force, wcb); // startujeme pripojeni

  wsStart();

  if (strlen(WiFiDeviceName) > 0)
  {
    nbns.begin(WiFiDeviceName);
  }

  ArduinoOTA.setHostname(WiFiDeviceName);
  ArduinoOTA.onStart([]() {
    DEBUG_OUT(F("Start\r\n"));
  });
  ArduinoOTA.onEnd([]() {
    DEBUG_OUT(F("End\r\n"));
  });
  ArduinoOTA.onError([](ota_error_t error) {
    DEBUG_OUT(F("Error["));
    DEBUG_OUT(error);
    DEBUG_OUT(F("]: "));
    switch (error)
    {
      case OTA_AUTH_ERROR:
        DEBUG_OUT(F("Auth Failed\r\n"));
        break;

      case OTA_BEGIN_ERROR:
        DEBUG_OUT(F("Begin Failed\r\n"));
        break;

      case OTA_CONNECT_ERROR:
        DEBUG_OUT(F("Connect Failed\r\n"));
        break;

      case OTA_RECEIVE_ERROR:
        DEBUG_OUT(F("Receive Failed\r\n"));
        break;

      case OTA_END_ERROR:
        DEBUG_OUT(F("End Failed\r\n"));
        break;

      default:
        DEBUG_OUT(F("\r\n"));
    }
  });
  ArduinoOTA.begin();
  if (SPIFFS.begin())
  {
    DEBUG_OUT(F("SPIFFS opened!"));
    ftpSrv.begin("esp8266", "esp8266"); // username, password for ftp.  set ports in ESP8266FtpServer.h  (default 21, 50009 for PASV)
  }
  // nastaveni vnitrnich promennych
  vars.create("version", __INOVERSION__); // jmeno a verze bezicicho skriptu
  vars.create("uptime", upTimeStr); // doba behu zarizeni
  vars.create("heap", getFreeHeap); // volna pamet
  vars.create("voltage"); // napeti
  vars.create("current"); // proud
  vars.create("power"); // prikon
  vars.create("energy"); // spotrebovana energie

  measure.set(3000); // merime po 3 sekundach
}


void readMeter(void)
{
  float v = meter.getVoltage();
  vars.setVal("voltage", String(v).c_str());
  float c = meter.getCurrent();
  vars.setVal("current", String(c).c_str());
  float p = meter.getPower();
  vars.setVal("power", String(p).c_str());
  int32_t e = meter.getEnergy();
  vars.setVal("energy", String(e).c_str());
}

void loop()
{

  wwwserver.handleClient(); // osetrujeme praci serveru
  ArduinoOTA.handle();
  ftpSrv.handleFTP();
  nbns.poll();
  meter.poll();
  if (measure.expired())
  {
    readMeter();
    measure.set(3000);
  }
}
// EOF
