/*
 * V2.4 - 7.2.2016  - upraveno casovani pri pripojovani k AP (zmizel delay(100))
 *
 * V2.3 - 5.2.2016  - pridano zverejneni jmena hosta a nastaveni tohoto jmena pro DHCP apod.
 *
 * V2.2 - 19.1.2016 - pridan Captive portal pri konfiguracnim AP.
 *
 * V2.1 - 20.9.2015 - pridano zadavani jmena zarizeni. Modul ho sice nevyuziva, ale aplikace ano a v pripade DHCP se dost hodi.
 *
 * V2.0 - 30.8.2015 - Podstatnym zpusobem vylepsena signalizace vnitrniho stavu, presunuto ulozeni rezimu (commit je uz zbytecny - udela se pri ukladani retezcu - uspora kodu)
 *
 * V1.2 - 23.8.2015 - BugFix - pridan chybejici eeprom.commit po ulozeni rezimu prace
 *
 * V1.1 - 5.8.2015 - pridana moznost volani callback metody pri behu konfiguracniho AP (signalizace stavu uzivatelskym zpusobem)
 *
 * V1.0 - publikace na www.xpablo.cz
 *
 * TODO:
 */
 
#include "WiFiConfig.h"
#include <DNSServer.h>
#include <EEPROM.h>
#include "embHTML.h"

extern "C" {
  #include "user_interface.h"
}

#define elementSize(type, element) sizeof(((type *)0)->element) 
#define DNS_PORT 53

char WiFiDeviceName[elementSize(wificonfigarea_t, devname)]; // misto pro jmeno zarizeni (dodane do DNS, DHCP NBNS apod...)

#define HTTP_200 F("HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n")
#define HTTP_HEAD F("<!DOCTYPE html><html lang=\"en\"><head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><title>{v}</title>")
#define HTTP_STYLE F("<style>div,input {margin-bottom: 5px;}body{width:200px;display:block;margin-left:auto;margin-right:auto;}</style>")
#define HTTP_SCRIPT F("<script>function c(l){document.getElementById('s').value=l.innerText||l.textContent;document.getElementById('p').focus();}</script>")
#define HTTP_HEAD_END F("</head><body>")
#define HTTP_ITEM F("<div><a href='#' onclick='c(this)'>{v}</a>({a}){s}</div>")
#define HTTP_FORM_1 F("<form method='get' action='s'><input id='s' name='ssid' length=32 {v}>")
#define HTTP_FORM_2 F("<input id='p' name='pass' length=64 {v} type='password'><br/><input id='n' name='name' length=32 {n}><br/>")
#define HTTP_FORM_3 F("<label><input id='a' name='AP' type='checkbox' {v}>AP mode</label><br/><input type='submit'></form>")
#define HTTP_END F("</body></html>")
	
static uint8_t testWifi(wificonfig_cb cb);

enum
{
	WIFIMODE_AP = 0x55, // rezim prace jako pristupovy bod (AP)
	WIFIMODE_STA = 0xAA // rezim prace jako klient
};

static int configBase;
static String content;

IPAddress getOurIP(void)
{

	if (WIFIMODE_STA == EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)))
		return WiFi.localIP();
	else
		return WiFi.softAPIP();
}

uint8_t * getOurMAC(uint8_t *mac)
{

	if (WIFIMODE_STA == EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)))
		return WiFi.macAddress(mac);
	else
		return WiFi.softAPmacAddress(mac);
}

String getEEPROMString(int start, int len)
{
  String string = "";
  
  for (int i = start; i < + start + len; ++i)
  {
    uint8_t b = EEPROM.read(i);

    if ((0xff == b) || (0 == b))
      break;
    string += char(b);
  }
  return string;
}

void setEEPROMString(int start, int len, String string)
{
  int si = 0;
  
  for (int i = start; i < start + len; ++i)
  {
    char c;
    
    if (si < string.length())
    {
      c = string[si];
    }
    else
    {
      c = 0;
    }
    EEPROM.write(i, c);
    ++si;
  }
  EEPROM.commit(); // skutecne ulozime retezec
}

void WiFiConfig::handleDisplayAP(void)
{
	String s;
	String v;
	
	content = HTTP_HEAD;
	content.replace("{v}", "xPablo.cz Config");
	content += HTTP_SCRIPT;
	content += HTTP_STYLE;
	content += HTTP_HEAD_END;
	int n = WiFi.scanNetworks();
	if (0 == n)
	{
		content += F("<div>No networks found. Refresh to scan again.</div>");
	}
	else
	{
		for (int i = 0; i < n; ++i)
		{
			String item = HTTP_ITEM;
			item.replace("{v}", WiFi.SSID(i));
			item.replace("{a}", String(WiFi.RSSI(i)));
			item.replace("{s}", (ENC_TYPE_NONE == WiFi.encryptionType(i)) ? " " : "*");
			content += item;
		}
	}
	s = HTTP_FORM_1;
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid));
	if (v.length())
		s.replace("{v}", "value='" + v + "'");
	else
		s.replace("{v}", "placeholder='SSID'");
	content += s;

	s = HTTP_FORM_2;
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, devname), elementSize(wificonfigarea_t, devname));
	if (v.length())
		s.replace("{n}", "value='" + v + "'");
	else
		s.replace("{n}", "placeholder='name'");
	v = getEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass));
	if (v.length())
		s.replace("{v}", "value='" + v + "'");
	else
		s.replace("{v}", "placeholder='password'");
	content += s;
	
	s = HTTP_FORM_3;
	if (EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)) == WIFIMODE_AP)
		s.replace("{v}", "checked='checked'");
	else
		s.replace("{v}", "");
	content += s;

	content += HTTP_END;
	server->send(200, F("text/html"), content);
}

void WiFiConfig::handleSetAP(void)
{
	uint8_t wmode;
	String qsid = server->arg("ssid");
	String qpass = server->arg("pass");
	String qap = server->arg("AP");
	String name = server->arg("name");
  
	if (qsid.length() > 0)
	{
		for (int i = 0; i < qsid.length(); i++)
		{
			// Deal with (potentially) plus-encoded ssid
			qsid[i] = (qsid[i] == '+' ? ' ' : qsid[i]);
		}
		for (int i = 0; i < qpass.length(); i++)
		{
			// Deal with (potentially) plus-encoded password
			qpass[i] = (qpass[i] == '+' ? ' ' : qpass[i]);
		}
		if (qap.length() > 0)
		{ // rezim AP
			wmode = WIFIMODE_AP;
		}
		else
		{ // rezim STA
			wmode = WIFIMODE_STA;
		}
		EEPROM.write(configBase + offsetof(wificonfigarea_t, mode), wmode);
		setEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid), qsid);
		setEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass), qpass);
		setEEPROMString(configBase + offsetof(wificonfigarea_t, devname), elementSize(wificonfigarea_t, devname), name);
//		EEPROM.commit(); // skutecne ulozime data
		content = HTTP_HEAD;
		content.replace("{v}", "Saved config");
		content += HTTP_STYLE;
		content += HTTP_HEAD_END;
		content += F("saved to eeprom...<br/>resetting in 10 seconds.");
		content += HTTP_END;
		server->send(200, F("text/html"), content);
		delay(10000); // cekame 10 sekund na odeslani dat
		ESP.restart();
	}
	else
	{
		content = HTTP_HEAD;
		content += F("Error, no ssid set?</html>");
		server->send(404, F("text/html"), content);
	}
}

// Start WiFi v rezimu AP pro nastaveni modulu
void WiFiConfig::setupAP(wificonfig_cb cb)
{

	dnsServer.reset(new DNSServer());
	server.reset(new ESP8266WebServer(80));
	
	/* Soft AP network parameters */
	IPAddress apIP(192, 168, 4, 1);
	IPAddress netMsk(255, 255, 255, 0); 

	WiFi.mode(WIFI_AP);

	WiFi.softAPConfig(apIP, apIP, netMsk); 
	WiFi.softAP(SETUP_SSID);
	delay(500); // dulezite - jinak se nevraci spravna IP adresa !!!

	dnsServer->setErrorReplyCode(DNSReplyCode::NoError);
	dnsServer->start(DNS_PORT, "*", WiFi.softAPIP()); // spustime tzv. Captive portal - vsechny DNS dotazy jsou smerovany na nasi ip adresu
	if (cb)
		cb(WCS_CONFIGSTART); // signalizujeme start konfiguracniho serveru
// Nastavime handlery weboveho serveru pro konfiguraci
	server->onNotFound(std::bind(&WiFiConfig::handleDisplayAP, this));
    server->on("/s", std::bind(&WiFiConfig::handleSetAP, this));
	server->begin(); // startujeme webovy server
	while (1)
	{
		server->handleClient(); // osetrujeme praci serveru
		if (cb)
			cb(WCS_CONFIGWAIT); // volame uzivatelsky callback (napr. signalizace)
		dnsServer->processNextRequest();
		delay(0); // procesy uvnitr systemu ESP potrebuji take svuj cas
	}
}

// Testovani, zda se modul pripojil k AP
static uint8_t testWifi(wificonfig_cb cb)
{
	uint32_t startt = millis();
  
	while ((millis() - startt) < WIFI_STA_CONNECT_TIMEOUT)
	{
		if (WiFi.status() == WL_CONNECTED)
		{
			return 1; // jsme pripojeni
		}
		delay(0);
		if (cb)
			cb(WCS_CONNECTING); // signalizujeme pokracujici pokus o spojeni
	}
	return 0; // pripojeni se nezdarilo
}
 
void WiFiConfig::begin(int configarea, uint8_t forceConfigure, wificonfig_cb cb)
{

	configBase = configarea; // pocatek konfigurace v EEPROM
	if (0 == forceConfigure)
	{
		setupAP(cb);
	}
	else
	{
		String ssid = getEEPROMString(configBase + offsetof(wificonfigarea_t, ssid), elementSize(wificonfigarea_t, ssid));
		String pass =  getEEPROMString(configBase + offsetof(wificonfigarea_t, pass), elementSize(wificonfigarea_t, pass));
		String hname = getEEPROMString(configBase + offsetof(wificonfigarea_t, devname), elementSize(wificonfigarea_t, devname));
		strcpy(WiFiDeviceName, hname.c_str());

		switch (EEPROM.read(configBase + offsetof(wificonfigarea_t, mode)))
		{
		case WIFIMODE_STA:
		{
			WiFi.mode(WIFI_STA); // startujeme WiFi v rezimu klienta
			if (strlen(WiFiDeviceName))
				WiFi.hostname(WiFiDeviceName); // nastavime jmeno zarizeni
			WiFi.begin(ssid.c_str(), pass.c_str());
			wifi_station_set_auto_connect(true);
			if (cb)
				cb(WCS_CONNECTSTART); // signalizujeme zacatek pokusu o pripojeni
			if (false == testWifi(cb))
				setupAP(cb); // modul se nepripojil - startujeme AP rezim
		}
		break;
		
		case WIFIMODE_AP:
			WiFi.mode(WIFI_AP); // startujeme AP
			if (pass.length())
			// je zadane heslo do AP
				WiFi.softAP(ssid.c_str(), pass.c_str());
			else
			// otevreny AP
				WiFi.softAP(ssid.c_str());
			if (cb)
				cb(WCS_CONNECTSTART); // signalizujeme zacatek pokusu o pripojeni (zde se nic jineho stejne nestane...)
		break;
		
		default: // jakykoliv neznamy rezim (mozna zavada na EEPROM???)
			setupAP(cb);
		break;
		}
	}
}
