#include <Arduino.h>
#include "variables.h"


struct Variables::varstruct
{
  varstruct(const char *name, TVarHandlerFunction f, const char *value)
    : name(name)
    , fn(f)
    , value(value)
    , lastModified(0)
    , next(NULL)
  {
  }

  String name;
  String value;
  TVarHandlerFunction fn;
  uint32_t lastModified;
  varstruct* next;
};

void Variables::flush(void)
{

  if (!_firstVar)
    return;
  varstruct* var = _firstVar;
  while (var)
  {
    varstruct* next = var->next;
    delete var;
    var = next;
  }
  _firstVar = NULL;
}

void Variables::create(const char *name, TVarHandlerFunction fn)
{
  varstruct* var = new varstruct(name, fn, NULL);

  var->next = _firstVar;
  _firstVar = var;
}

void Variables::create(const char *name, const char *value)
{
  varstruct* var = new varstruct(name, NULL, value);

  var->next = _firstVar;
  _firstVar = var;
}

void Variables::setVal(const char *name, const char *value)
{
  varstruct* var;

  for (var = _firstVar; var; var = var->next)
  {
    if (0 != strcmp(var->name.c_str(), name))
      //    if (var->name.equalsIgnoreCase(String(name)))
      continue;

    var->value = value;
    var->lastModified = millis();
    break;
  }

}

uint32_t Variables::getAge(char *name)
{
  varstruct* var;
  uint32_t age = -1;

  for (var = _firstVar; var; var = var->next)
  {
    if (0 != strcmp(var->name.c_str(), name))
      //    if (var->name.equalsIgnoreCase(String(name)))
      continue;

    age = millis() - var->lastModified;
    break;
  }
  return age;
}

void Variables::append(const char *name, const char *value)
{
  varstruct* var;

  for (var = _firstVar; var; var = var->next)
  {
    if (0 != strcmp(var->name.c_str(), name))
      //		if (var->name.equalsIgnoreCase(String(name)))
      continue;

    var->value += value;
    var->lastModified = millis();
    break;
  }
}

const char *Variables::getVal(char *name)
{
  varstruct* var;

  for (var = _firstVar; var; var = var->next)
  {
    if (0 != strcmp(var->name.c_str(), name))
      continue;

    break;
  }
  if (NULL == var)
    return NULL;
  else if (var->fn)
    return var->fn();
  else
    return var->value.c_str();
}

void Variables::getFirst(char **name, char **value, uint32_t *lastTouch)
{

  *name = NULL;
  if (_firstVar)
  {
    _active = _firstVar;
    *name = (char *)_active->name.c_str();
    if (_active->fn)
      *value = _active->fn();
    else
      *value = (char *)_active->value.c_str();
    if (lastTouch)
    {
      if (NULL != _active->fn)
        *lastTouch = 0; // promenna, ziskana funkci ma vzdycky aktualni hodnotu
      else
        *lastTouch = millis() - _active->lastModified;
    }
  }
}

void Variables::getNext(char **name, char **value, uint32_t *lastTouch)
{

  *name = NULL;
  if (_active)
  {
    _active = _active->next;
    if (_active)
    {
      *name = (char *)_active->name.c_str();
      if (_active->fn)
        *value = _active->fn();
      else
        *value = (char *)_active->value.c_str();
      if (lastTouch)
      {
        if (NULL != _active->fn)
          *lastTouch = 0; // promenna, ziskana funkci ma vzdycky aktualni hodnotu
        else
          *lastTouch = millis() - _active->lastModified;
      }
    }
  }
}

// EOF
