// www.xpablo.cz
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <EEPROM.h>
#include <WiFiConfig.h>
//#include <ESP8266mDNS.h>
#include <WiFiUdp.h>
#include <ArduinoOTA.h>
#include <ESP8266FtpServer.h>
#include <SoftwareSerial.h>
#include "variables.h"
#include "cgiws.h"
#include "comm.h"

#define FORCE_CONFIG_BUTTON_PIN 3
#define LED_PIN 13
#define USB_BAUD 115200
//#define DEBUG_OUT(a) {}
#define DEBUG_OUT(a) Serial.print(a)

#define __VERSION__ __FILE__ " Compiled @" __DATE__ " " __TIME__

FtpServer ftpSrv;   //set #define FTP_DEBUG in ESP8266FtpServer.h to see ftp verbose on serial
ESP8266WebServer wwwserver(80); // webovy server - pouzity je jak pro nastaveni ESP modulu pomoci WifiConfig, tak pro praci aplikace
String content;
WifiConfig wifi; // konfigurace ESP modulu
Variables vars; // komunikacni promenne
Comm comm(Serial); // seriova komunikace

char tempStrBuff[256]; // pomocny buffer pro navratove hodnoty z promennych, ovladanych volanim

static char *Send(void)
{

  sprintf(tempStrBuff, "Sent...");
  for (uint8_t i = 0; i < wwwserver.args(); i++ )
  {
    comm.send(wwwserver.argName(i), wwwserver.arg(i));
  }
    return tempStrBuff;
}

static char *upTimeStr(void)
{
    int uptimesec = millis() / 1000;
    int uptimemin = uptimesec / 60;
    int uptimehr  = uptimemin / 60;
    int uptimeday = uptimehr  / 24;

    uptimesec %= 60;
    uptimemin %= 60;
    uptimehr  %= 24;

    snprintf(tempStrBuff, sizeof(tempStrBuff), "%d Days, %02d:%02d:%02d", uptimeday, uptimehr, uptimemin, uptimesec );
    return tempStrBuff;
}

static char *getFreeHeap(void)
{

  snprintf(tempStrBuff, sizeof(tempStrBuff), "%d", ESP.getFreeHeap());
  return tempStrBuff;
}

void ICACHE_FLASH_ATTR wcb(wificonfigstate_t state)
{

  switch (state)
  {
    case WCS_CONNECTSTART:
      DEBUG_OUT(F("Starting connect...\r\n"));
      break;

    case WCS_CONNECTING:
      break;

    case WCS_CONFIGSTART:
      DEBUG_OUT(F("Starting config...\r\n"));
      break;

    case WCS_CONFIGWAIT:
      break;
  }
}

void ICACHE_FLASH_ATTR setup(void)
{

  EEPROM.begin(512); // zahajujeme praci s EEPROM
  pinMode(FORCE_CONFIG_BUTTON_PIN, INPUT_PULLUP); // RXD slouzi jako vstup tlacitka
  delay(10);
  int force = digitalRead(FORCE_CONFIG_BUTTON_PIN);
  Serial.begin(USB_BAUD);
  DEBUG_OUT(F("\r\nStarting up...\r\n"));
  wifi.begin(0, force, wcb); // startujeme pripojeni

  DEBUG_OUT(F("Our IP: "));
  DEBUG_OUT(getOurIP());
  DEBUG_OUT(F("\r\n"));

  wsStart();

  //  ArduinoOTA.setHostname();
  ArduinoOTA.onStart([]() {
    DEBUG_OUT(F("Start\r\n"));
  });
  ArduinoOTA.onEnd([]() {
    DEBUG_OUT(F("End\r\n"));
  });
  ArduinoOTA.onError([](ota_error_t error) {
    DEBUG_OUT(F("Error["));
    DEBUG_OUT(error);
    DEBUG_OUT(F("]: "));
    switch (error)
    {
      case OTA_AUTH_ERROR:
        DEBUG_OUT(F("Auth Failed\r\n"));
        break;

      case OTA_BEGIN_ERROR:
        DEBUG_OUT(F("Begin Failed\r\n"));
        break;

      case OTA_CONNECT_ERROR:
        DEBUG_OUT(F("Connect Failed\r\n"));
        break;

      case OTA_RECEIVE_ERROR:
        DEBUG_OUT(F("Receive Failed\r\n"));
        break;

      case OTA_END_ERROR:
        DEBUG_OUT(F("End Failed\r\n"));
        break;

      default:
        DEBUG_OUT(F("\r\n"));
    }
  });
  ArduinoOTA.begin();
  if (SPIFFS.begin())
  {
    DEBUG_OUT(F("SPIFFS opened!"));
    ftpSrv.begin("esp8266", "esp8266"); // username, password for ftp.  set ports in ESP8266FtpServer.h  (default 21, 50009 for PASV)
  }
  // nastaveni vnitrnich promennych
  vars.create("version", __VERSION__); // jmeno a verze bezicicho skriptu
  vars.create("uptime", upTimeStr); // doba behu zarizeni
  vars.create("heap", getFreeHeap); // volna pamet
  vars.create("send", Send); // odeslani ridicich parametru na vystup

  // nacteni promennych ze souboru
  File varfile = SPIFFS.open("/variables.txt", "r");
  if (varfile)
  {
    while (varfile.available())
    {
      String line = varfile.readStringUntil('\n');

      if (!line.startsWith(";"))
      { // neni to komentar
        line.trim(); // odstranime uvodni a koncove mezery
        vars.create(line.c_str()); // vytvorime prazdnou promennou
      }
    }
	varfile.close();
  }
}

void loop(void)
{

  wwwserver.handleClient(); // osetrujeme praci serveru
  ArduinoOTA.handle();
  ftpSrv.handleFTP();
  comm.handle();
}

// EOF
